/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.approximate;

import java.io.IOException;
import java.util.Objects;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryVisitor;
import org.opensearch.index.mapper.MappedFieldType;
import org.opensearch.search.approximate.ApproximateQuery;
import org.opensearch.search.approximate.ApproximateScoreQuery;
import org.opensearch.search.internal.SearchContext;
import org.opensearch.search.sort.FieldSortBuilder;

public class ApproximateMatchAllQuery
extends ApproximateQuery {
    private ApproximateQuery approximation = null;

    @Override
    protected boolean canApproximate(SearchContext context) {
        this.approximation = null;
        if (context == null) {
            return false;
        }
        if (context.aggregations() != null) {
            return false;
        }
        if (context.trackTotalHitsUpTo() == Integer.MAX_VALUE) {
            return false;
        }
        if (context.request() != null && context.request().source() != null && context.innerHits().getInnerHits().isEmpty()) {
            if (context.request().source().sorts() != null && context.request().source().sorts().size() > 1) {
                return false;
            }
            FieldSortBuilder primarySortField = FieldSortBuilder.getPrimaryFieldSortOrNull(context.request().source());
            if (primarySortField != null && primarySortField.missing() == null && !primarySortField.fieldName().equals("_doc") && !primarySortField.fieldName().equals("_id")) {
                MappedFieldType mappedFieldType = context.getQueryShardContext().fieldMapper(primarySortField.fieldName());
                if (mappedFieldType == null) {
                    return false;
                }
                Query rangeQuery = mappedFieldType.rangeQuery(null, null, false, false, null, null, null, context.getQueryShardContext());
                if (rangeQuery instanceof ApproximateScoreQuery) {
                    ApproximateScoreQuery approximateScoreQuery = (ApproximateScoreQuery)rangeQuery;
                    approximateScoreQuery.setContext(context);
                    if (approximateScoreQuery.resolvedQuery instanceof ApproximateQuery) {
                        this.approximation = (ApproximateQuery)approximateScoreQuery.resolvedQuery;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    @Override
    public String toString(String field) {
        return "Approximate(*:*)";
    }

    @Override
    public void visit(QueryVisitor visitor) {
        visitor.visitLeaf(this);
    }

    @Override
    public boolean equals(Object o) {
        if (this.sameClassAs(o)) {
            ApproximateMatchAllQuery other = (ApproximateMatchAllQuery)o;
            return Objects.equals(this.approximation, other.approximation);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.classHash();
    }

    @Override
    public Query rewrite(IndexSearcher indexSearcher) throws IOException {
        if (this.approximation == null) {
            throw new IllegalStateException("rewrite called without setting context or query could not be approximated");
        }
        return this.approximation.rewrite(indexSearcher);
    }
}

