/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.profile.fetch;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.opensearch.common.annotation.ExperimentalApi;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentFragment;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.search.profile.ProfileResult;

@ExperimentalApi
public class FetchProfileShardResult
implements Writeable,
ToXContentFragment {
    public static final String FETCH = "fetch";
    private final List<ProfileResult> fetchProfileResults;

    public FetchProfileShardResult(List<ProfileResult> results) {
        this.fetchProfileResults = Collections.unmodifiableList(results);
    }

    public FetchProfileShardResult(StreamInput in) throws IOException {
        int profileSize = in.readVInt();
        ArrayList<ProfileResult> tmp = new ArrayList<ProfileResult>(profileSize);
        for (int j = 0; j < profileSize; ++j) {
            tmp.add(new ProfileResult(in));
        }
        this.fetchProfileResults = Collections.unmodifiableList(tmp);
    }

    public List<ProfileResult> getFetchProfileResults() {
        return this.fetchProfileResults;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVInt(this.fetchProfileResults.size());
        for (ProfileResult p : this.fetchProfileResults) {
            p.writeTo(out);
        }
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startArray(FETCH);
        for (ProfileResult p : this.fetchProfileResults) {
            p.toXContent(builder, params);
        }
        return builder.endArray();
    }

    public static FetchProfileShardResult fromXContent(XContentParser parser) throws IOException {
        XContentParserUtils.ensureExpectedToken(XContentParser.Token.START_ARRAY, parser.currentToken(), parser);
        ArrayList<ProfileResult> results = new ArrayList<ProfileResult>();
        while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
            results.add(ProfileResult.fromXContent(parser));
        }
        return new FetchProfileShardResult(results);
    }
}

