/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.profile.query;

import java.io.IOException;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.ScorerSupplier;
import org.apache.lucene.search.Weight;
import org.opensearch.search.profile.ContextualProfileBreakdown;
import org.opensearch.search.profile.Timer;
import org.opensearch.search.profile.query.ProfileScorer;
import org.opensearch.search.profile.query.QueryTimingType;

public final class ProfileWeight
extends Weight {
    private final Weight subQueryWeight;
    private final ContextualProfileBreakdown profile;

    public ProfileWeight(Query query, Weight subQueryWeight, ContextualProfileBreakdown profile) throws IOException {
        super(query);
        this.subQueryWeight = subQueryWeight;
        this.profile = profile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ScorerSupplier scorerSupplier(final LeafReaderContext context) throws IOException {
        ScorerSupplier subQueryScorerSupplier;
        final Timer timer = this.profile.context(context).getTimer(QueryTimingType.BUILD_SCORER);
        timer.start();
        try {
            subQueryScorerSupplier = this.subQueryWeight.scorerSupplier(context);
        }
        finally {
            timer.stop();
        }
        if (subQueryScorerSupplier == null) {
            return null;
        }
        return new ScorerSupplier(this){
            final /* synthetic */ ProfileWeight this$0;
            {
                this.this$0 = this$0;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Scorer get(long loadCost) throws IOException {
                timer.start();
                try {
                    ProfileScorer profileScorer = new ProfileScorer(subQueryScorerSupplier.get(loadCost), this.this$0.profile.context(context));
                    return profileScorer;
                }
                finally {
                    timer.stop();
                }
            }

            @Override
            public long cost() {
                timer.start();
                try {
                    long l = subQueryScorerSupplier.cost();
                    return l;
                }
                finally {
                    timer.stop();
                }
            }
        };
    }

    @Override
    public Explanation explain(LeafReaderContext context, int doc) throws IOException {
        return this.subQueryWeight.explain(context, doc);
    }

    @Override
    public int count(LeafReaderContext context) throws IOException {
        return this.subQueryWeight.count(context);
    }

    @Override
    public boolean isCacheable(LeafReaderContext ctx) {
        return false;
    }

    public void associateCollectorToLeaves(LeafReaderContext leaf, Collector collector) {
        this.profile.associateCollectorToLeaves(collector, leaf);
    }
}

