/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.query;

import java.io.IOException;
import java.util.Objects;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.search.ConstantScoreScorer;
import org.apache.lucene.search.ConstantScoreWeight;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryVisitor;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.ScorerSupplier;
import org.apache.lucene.search.TwoPhaseIterator;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.RamUsageEstimator;
import org.opensearch.search.query.BitmapIndexQuery;
import org.roaringbitmap.RoaringBitmap;

public class BitmapDocValuesQuery
extends Query
implements Accountable {
    final String field;
    final RoaringBitmap bitmap;
    final long min;
    final long max;

    public BitmapDocValuesQuery(String field, RoaringBitmap bitmap) {
        BitmapIndexQuery.checkArgs(field, bitmap);
        this.field = field;
        this.bitmap = bitmap;
        if (!bitmap.isEmpty()) {
            this.min = bitmap.first();
            this.max = bitmap.last();
        } else {
            this.min = 0L;
            this.max = 0L;
        }
    }

    @Override
    public Weight createWeight(IndexSearcher searcher, final ScoreMode scoreMode, float boost) throws IOException {
        return new ConstantScoreWeight(this, this, boost){
            final /* synthetic */ BitmapDocValuesQuery this$0;
            {
                this.this$0 = this$0;
                super(query, score);
            }

            @Override
            public ScorerSupplier scorerSupplier(LeafReaderContext context) throws IOException {
                final SortedNumericDocValues values = DocValues.getSortedNumeric(context.reader(), this.this$0.field);
                final NumericDocValues singleton = DocValues.unwrapSingleton(values);
                TwoPhaseIterator iterator = singleton != null ? new TwoPhaseIterator(this, singleton){
                    final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = this$1;
                        super(approximation);
                    }

                    @Override
                    public boolean matches() throws IOException {
                        long value = singleton.longValue();
                        return value >= this.this$1.this$0.min && value <= this.this$1.this$0.max && this.this$1.this$0.bitmap.contains((int)value);
                    }

                    @Override
                    public float matchCost() {
                        return 5.0f;
                    }
                } : new TwoPhaseIterator(this, values){
                    final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = this$1;
                        super(approximation);
                    }

                    @Override
                    public boolean matches() throws IOException {
                        int count = values.docValueCount();
                        for (int i = 0; i < count; ++i) {
                            long value = values.nextValue();
                            if (value < this.this$1.this$0.min) continue;
                            if (value > this.this$1.this$0.max) {
                                return false;
                            }
                            if (!this.this$1.this$0.bitmap.contains((int)value)) continue;
                            return true;
                        }
                        return false;
                    }

                    @Override
                    public float matchCost() {
                        return 5.0f;
                    }
                };
                ConstantScoreScorer scorer = new ConstantScoreScorer(this.score(), scoreMode, iterator);
                return new Weight.DefaultScorerSupplier(scorer);
            }

            @Override
            public boolean isCacheable(LeafReaderContext ctx) {
                return DocValues.isCacheable(ctx, this.this$0.field);
            }
        };
    }

    @Override
    public String toString(String field) {
        return "BitmapDocValuesQuery(field=" + this.field + ")";
    }

    @Override
    public Query rewrite(IndexSearcher indexSearcher) throws IOException {
        if (this.bitmap.isEmpty()) {
            return new MatchNoDocsQuery();
        }
        return super.rewrite(indexSearcher);
    }

    @Override
    public boolean equals(Object other) {
        if (!this.sameClassAs(other)) {
            return false;
        }
        BitmapDocValuesQuery that = (BitmapDocValuesQuery)other;
        return this.field.equals(that.field) && this.bitmap.equals((Object)that.bitmap);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.classHash(), this.field, this.bitmap);
    }

    @Override
    public long ramBytesUsed() {
        return RamUsageEstimator.shallowSizeOfInstance(BitmapIndexQuery.class) + RamUsageEstimator.sizeOf(this.field) + this.bitmap.getLongSizeInBytes();
    }

    @Override
    public void visit(QueryVisitor visitor) {
        if (visitor.acceptField(this.field)) {
            visitor.visitLeaf(this);
        }
    }
}

