/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.query;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.CollectorManager;
import org.apache.lucene.search.Weight;
import org.opensearch.common.lucene.search.FilteredCollector;
import org.opensearch.search.query.ReduceableSearchResult;

class FilteredCollectorManager
implements CollectorManager<FilteredCollector, ReduceableSearchResult> {
    private final CollectorManager<? extends Collector, ReduceableSearchResult> manager;
    private final Weight filter;

    FilteredCollectorManager(CollectorManager<? extends Collector, ReduceableSearchResult> manager, Weight filter) {
        this.manager = manager;
        this.filter = filter;
    }

    @Override
    public FilteredCollector newCollector() throws IOException {
        return new FilteredCollector(this.manager.newCollector(), this.filter);
    }

    @Override
    public ReduceableSearchResult reduce(Collection<FilteredCollector> collectors) throws IOException {
        ArrayList<Collector> subCollectors = new ArrayList<Collector>();
        for (FilteredCollector collector : collectors) {
            subCollectors.add(collector.getCollector());
        }
        return this.manager.reduce(subCollectors);
    }
}

