/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.telemetry.tracing.listener;

import java.util.Objects;
import org.opensearch.core.action.ActionListener;
import org.opensearch.telemetry.tracing.Span;
import org.opensearch.telemetry.tracing.SpanScope;
import org.opensearch.telemetry.tracing.Tracer;

public class TraceableActionListener<Response>
implements ActionListener<Response> {
    private final ActionListener<Response> delegate;
    private final Span span;
    private final Tracer tracer;

    private TraceableActionListener(ActionListener<Response> delegate, Span span, Tracer tracer) {
        this.delegate = Objects.requireNonNull(delegate);
        this.span = Objects.requireNonNull(span);
        this.tracer = Objects.requireNonNull(tracer);
    }

    public static <Response> ActionListener<Response> create(ActionListener<Response> delegate, Span span, Tracer tracer) {
        if (tracer.isRecording()) {
            return new TraceableActionListener<Response>(delegate, span, tracer);
        }
        return delegate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onResponse(Response response) {
        try (SpanScope scope = this.tracer.withSpanInScope(this.span);){
            this.delegate.onResponse(response);
        }
        finally {
            this.span.endSpan();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onFailure(Exception e) {
        try (SpanScope scope = this.tracer.withSpanInScope(this.span);){
            this.delegate.onFailure(e);
        }
        finally {
            this.span.setError(e);
            this.span.endSpan();
        }
    }
}

