/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.transport;

import java.io.IOException;
import java.util.function.Function;
import org.opensearch.common.annotation.ExperimentalApi;
import org.opensearch.common.annotation.PublicApi;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.transport.TransportResponse;
import org.opensearch.transport.TransportException;
import org.opensearch.transport.stream.StreamTransportResponse;

@PublicApi(since="1.0.0")
public interface TransportResponseHandler<T extends TransportResponse>
extends Writeable.Reader<T> {
    public void handleResponse(T var1);

    @ExperimentalApi
    default public void handleStreamResponse(StreamTransportResponse<T> response) {
        throw new UnsupportedOperationException("Streaming responses not supported by this handler");
    }

    public void handleException(TransportException var1);

    public String executor();

    default public void handleRejection(Exception exp) {
    }

    default public <Q extends TransportResponse> TransportResponseHandler<Q> wrap(final Function<Q, T> converter, final Writeable.Reader<Q> reader) {
        final TransportResponseHandler self = this;
        return new TransportResponseHandler<Q>(){

            @Override
            public void handleResponse(Q response) {
                self.handleResponse((TransportResponse)converter.apply(response));
            }

            @Override
            public void handleException(TransportException exp) {
                self.handleException(exp);
            }

            @Override
            public String executor() {
                return self.executor();
            }

            @Override
            public Q read(StreamInput in) throws IOException {
                return (TransportResponse)reader.read(in);
            }
        };
    }
}

