/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.paxjdbcfeature;

import de.virtimo.bpc.util.StringUtil;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PaxJdbcFeaturesToInstall {
    private static final Logger LOGGER = LogManager.getLogger(PaxJdbcFeaturesToInstall.class);
    private final Set<String> featuresToInstallWithoutCustomJdbcDriver = new HashSet<String>();
    private final Set<String> featuresToInstallWithCustomJdbcDriver = new HashSet<String>();

    public PaxJdbcFeaturesToInstall(String value) {
        if (!StringUtil.isNullOrEmpty((String)value)) {
            this.parseValue(value);
        }
    }

    public boolean hasFeaturesToInstall() {
        return this.hasFeaturesToInstallWithoutCustomJdbcDriver() || this.hasFeaturesToInstallWithCustomJdbcDriver();
    }

    public boolean hasFeaturesToInstallWithoutCustomJdbcDriver() {
        return !this.featuresToInstallWithoutCustomJdbcDriver.isEmpty();
    }

    public Set<String> getFeaturesToInstallWithoutCustomJdbcDriver() {
        return this.featuresToInstallWithoutCustomJdbcDriver;
    }

    public boolean hasFeaturesToInstallWithCustomJdbcDriver() {
        return !this.featuresToInstallWithCustomJdbcDriver.isEmpty();
    }

    public Set<String> getFeaturesToInstallWithCustomJdbcDriver() {
        return this.featuresToInstallWithCustomJdbcDriver;
    }

    private boolean isValidPaxJdbcFeatureName(String featureName) {
        return featureName.toLowerCase().startsWith("pax-jdbc-") && !featureName.contains(" ");
    }

    private void parseValue(String value) {
        LOGGER.info("parseValue value={}", (Object)value);
        List features = StringUtil.explode((String)value, (String)",");
        for (String feature : features) {
            String featureName;
            if (feature.contains("(*)")) {
                featureName = feature.replace("(*)", "").trim();
                if (this.isValidPaxJdbcFeatureName(featureName)) {
                    this.featuresToInstallWithCustomJdbcDriver.add(featureName);
                    continue;
                }
                LOGGER.warn("Found an invalid pax-jdbc feature which cannot be installed: {}", (Object)feature);
                continue;
            }
            featureName = feature.trim();
            if (this.isValidPaxJdbcFeatureName(featureName)) {
                this.featuresToInstallWithoutCustomJdbcDriver.add(featureName);
                continue;
            }
            LOGGER.warn("Found an invalid pax-jdbc feature which cannot be installed: {}", (Object)feature);
        }
    }
}

