/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.tx.control.service.common.impl;

import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.apache.aries.tx.control.service.common.impl.AbstractTransactionContextImpl;
import org.apache.aries.tx.control.service.common.impl.NoTransactionContextImpl;
import org.osgi.service.transaction.control.ScopedWorkException;
import org.osgi.service.transaction.control.TransactionBuilder;
import org.osgi.service.transaction.control.TransactionContext;
import org.osgi.service.transaction.control.TransactionControl;
import org.osgi.service.transaction.control.TransactionException;
import org.osgi.service.transaction.control.TransactionRolledBackException;
import org.osgi.service.transaction.control.TransactionStatus;

public abstract class AbstractTransactionControlImpl
implements TransactionControl {
    private final ThreadLocal<AbstractTransactionContextImpl> existingTx = new ThreadLocal();
    private final AtomicBoolean closed = new AtomicBoolean();

    protected abstract AbstractTransactionContextImpl startTransaction(boolean var1);

    @Override
    public TransactionBuilder build() {
        return new TransactionBuilderImpl();
    }

    @Override
    public boolean getRollbackOnly() throws IllegalStateException {
        return this.getCurrentTranContextChecked().getRollbackOnly();
    }

    @Override
    public void setRollbackOnly() throws IllegalStateException {
        this.getCurrentTranContextChecked().setRollbackOnly();
    }

    @Override
    public <T> T required(Callable<T> work) throws TransactionException, TransactionRolledBackException {
        return this.build().required(work);
    }

    @Override
    public <T> T requiresNew(Callable<T> work) throws TransactionException, TransactionRolledBackException {
        return this.build().requiresNew(work);
    }

    @Override
    public <T> T notSupported(Callable<T> work) throws TransactionException {
        return this.build().notSupported(work);
    }

    @Override
    public <T> T supports(Callable<T> work) throws TransactionException {
        return this.build().supports(work);
    }

    @Override
    public boolean activeTransaction() {
        TransactionContext context = this.getCurrentContext();
        return context != null && context.getTransactionStatus() != TransactionStatus.NO_TRANSACTION;
    }

    @Override
    public boolean activeScope() {
        return this.getCurrentContext() != null;
    }

    private AbstractTransactionContextImpl getCurrentTranContextChecked() {
        AbstractTransactionContextImpl toUse = this.existingTx.get();
        if (toUse == null) {
            throw new IllegalStateException("There is no applicable transaction context");
        }
        return toUse;
    }

    @Override
    public TransactionContext getCurrentContext() {
        return this.existingTx.get();
    }

    @Override
    public void ignoreException(Throwable t) throws IllegalStateException {
        this.getCurrentTranContextChecked().ignoreException(t);
    }

    public void close() {
        this.closed.set(true);
    }

    private final class TransactionBuilderImpl
    extends TransactionBuilder {
        private boolean readOnly = false;

        private TransactionBuilderImpl() {
        }

        @Override
        public TransactionBuilder readOnly() {
            this.readOnly = true;
            return this;
        }

        private void checkValid() {
            if (AbstractTransactionControlImpl.this.closed.get()) {
                throw new TransactionException("The transaction control service is closed");
            }
            List duplicates = this.rollbackFor.stream().filter(this.noRollbackFor::contains).collect(Collectors.toList());
            if (!duplicates.isEmpty()) {
                throw new TransactionException("The transaction declares that the Exceptions " + duplicates + " must both trigger and not trigger rollback");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <T> T required(Callable<T> work) throws TransactionException, TransactionRolledBackException {
            this.checkValid();
            boolean endTransaction = false;
            AbstractTransactionContextImpl existingTran = (AbstractTransactionContextImpl)AbstractTransactionControlImpl.this.existingTx.get();
            try {
                AbstractTransactionContextImpl currentTran;
                if (existingTran == null || existingTran.getTransactionStatus() == TransactionStatus.NO_TRANSACTION) {
                    currentTran = AbstractTransactionControlImpl.this.startTransaction(this.readOnly);
                    endTransaction = true;
                    AbstractTransactionControlImpl.this.existingTx.set(currentTran);
                } else {
                    if (existingTran.isReadOnly() && !this.readOnly) {
                        throw new TransactionException("A read only transaction is currently active, and cannot be upgraded to a writeable transaction");
                    }
                    currentTran = existingTran;
                }
                T t = this.doWork(work, currentTran, endTransaction);
                return t;
            }
            finally {
                AbstractTransactionControlImpl.this.existingTx.set(existingTran);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <T> T requiresNew(Callable<T> work) throws TransactionException, TransactionRolledBackException {
            this.checkValid();
            AbstractTransactionContextImpl existingTran = (AbstractTransactionContextImpl)AbstractTransactionControlImpl.this.existingTx.get();
            try {
                AbstractTransactionContextImpl currentTran = AbstractTransactionControlImpl.this.startTransaction(this.readOnly);
                AbstractTransactionControlImpl.this.existingTx.set(currentTran);
                T t = this.doWork(work, currentTran, true);
                return t;
            }
            finally {
                AbstractTransactionControlImpl.this.existingTx.set(existingTran);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <T> T supports(Callable<T> work) throws TransactionException {
            this.checkValid();
            boolean endTransaction = false;
            AbstractTransactionContextImpl existingTran = (AbstractTransactionContextImpl)AbstractTransactionControlImpl.this.existingTx.get();
            try {
                AbstractTransactionContextImpl currentTran;
                if (existingTran == null) {
                    currentTran = new NoTransactionContextImpl();
                    endTransaction = true;
                    AbstractTransactionControlImpl.this.existingTx.set(currentTran);
                } else {
                    currentTran = existingTran;
                }
                T t = this.doWork(work, currentTran, endTransaction);
                return t;
            }
            finally {
                AbstractTransactionControlImpl.this.existingTx.set(existingTran);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <T> T notSupported(Callable<T> work) throws TransactionException {
            this.checkValid();
            boolean endTransaction = false;
            AbstractTransactionContextImpl existingTran = (AbstractTransactionContextImpl)AbstractTransactionControlImpl.this.existingTx.get();
            try {
                AbstractTransactionContextImpl currentTran;
                if (existingTran == null || existingTran.getTransactionStatus() != TransactionStatus.NO_TRANSACTION) {
                    currentTran = new NoTransactionContextImpl();
                    endTransaction = true;
                    AbstractTransactionControlImpl.this.existingTx.set(currentTran);
                } else {
                    currentTran = existingTran;
                }
                T t = this.doWork(work, currentTran, endTransaction);
                return t;
            }
            finally {
                AbstractTransactionControlImpl.this.existingTx.set(existingTran);
            }
        }

        private <R> R doWork(Callable<R> transactionalWork, AbstractTransactionContextImpl currentTran, boolean endTransaction) {
            Throwable throwable;
            R result;
            try {
                result = transactionalWork.call();
            }
            catch (Throwable t) {
                ScopedWorkException workException;
                AbstractTransactionContextImpl toPropagate;
                if (!currentTran.ignoredExceptions.contains(t) && this.requiresRollback(t)) {
                    currentTran.safeSetRollbackOnly();
                }
                if (endTransaction) {
                    try {
                        currentTran.finish();
                    }
                    catch (Exception e) {
                        currentTran.recordFailure(e);
                    }
                }
                AbstractTransactionContextImpl abstractTransactionContextImpl = toPropagate = endTransaction ? null : currentTran;
                if (t instanceof ScopedWorkException) {
                    workException = new ScopedWorkException("A nested piece of scoped work threw an exception", t.getCause(), toPropagate);
                    workException.addSuppressed(t);
                } else {
                    workException = new ScopedWorkException("The scoped work threw an exception", t, toPropagate);
                }
                Throwable throwable2 = currentTran.firstUnexpectedException.get();
                if (throwable2 != null) {
                    workException.addSuppressed(throwable2);
                }
                currentTran.subsequentExceptions.stream().forEach(workException::addSuppressed);
                throw workException;
            }
            if (endTransaction) {
                try {
                    currentTran.finish();
                }
                catch (Exception e) {
                    currentTran.recordFailure(e);
                }
            }
            if ((throwable = currentTran.firstUnexpectedException.get()) != null) {
                TransactionException te = currentTran.getTransactionStatus() == TransactionStatus.ROLLED_BACK ? new TransactionRolledBackException("The transaction rolled back due to a failure", throwable) : new TransactionException("There was an error in the Transaction completion.", throwable);
                currentTran.subsequentExceptions.stream().forEach(te::addSuppressed);
                throw te;
            }
            return result;
        }

        private boolean requiresRollback(Throwable t) {
            return this.mostSpecificMatch(this.noRollbackFor, t).map(noRollbackType -> this.mostSpecificMatch(this.rollbackFor, t).map(rollbackType -> noRollbackType.isAssignableFrom((Class<?>)rollbackType)).orElse(false)).orElse(true);
        }

        private Optional<Class<? extends Throwable>> mostSpecificMatch(Collection<Class<? extends Throwable>> types, Throwable t) {
            return types.stream().filter(c -> c.isInstance(t)).max((c1, c2) -> {
                if (c1 == c2) {
                    return 0;
                }
                return c1.isAssignableFrom((Class<?>)c2) ? 1 : (c2.isAssignableFrom((Class<?>)c1) ? -1 : 0);
            });
        }
    }
}

