/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.replay.driver;

import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLRecoverableException;
import java.sql.Statement;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.logging.Level;
import oracle.jdbc.diagnostics.CommonDiagnosable;
import oracle.jdbc.diagnostics.Diagnosable;
import oracle.jdbc.diagnostics.SecurityLabel;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.internal.Monitor;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.replay.driver.FailoverManager;
import oracle.jdbc.replay.driver.NonTxnReplayableBase;
import oracle.jdbc.replay.driver.NonTxnReplayableConnection;
import oracle.jdbc.replay.driver.Replayable;
import oracle.jdbc.replay.internal.ConnectionInitializationCallback;
import oracle.jdbc.replay.internal.OracleDataSource;

class FailoverManagerImpl
implements FailoverManager,
Monitor,
Diagnosable {
    private static final String MONITOR_TXN = "BEGIN DBMS_APP_CONT_PRVT.MONITOR_TXN; END;";
    private static final String BEGIN_REPLAY = "BEGIN DBMS_APP_CONT_PRVT.BEGIN_REPLAY; END;";
    private static final String END_REPLAY = "BEGIN DBMS_APP_CONT_PRVT.END_REPLAY; END;";
    private CallHistoryEntry head;
    private CallHistoryEntry tail;
    private ReplayLifecycle lifecycle = ReplayLifecycle.INTERNALLY_DISABLED;
    private boolean replayInCurrentMode = false;
    private Object replayResult;
    private long requestStartTime;
    private long replayInitiationTimeout = 900L;
    private static final int REPLAY_RETRIES = 3;
    private int replayRetries = 0;
    private OracleDataSource replayDataSource = null;
    private NonTxnReplayableBase connectionProxy;
    private Method callCausingReplayError;
    private int replayErrorCode;
    private String replayErrorMessage;
    private static final ExecutorService executor = Executors.newSingleThreadExecutor(new ThreadFactory(){
        private static final String THREAD_NAME = "OJDBC-AC-WORKER-THREAD";

        @Override
        public Thread newThread(Runnable r) {
            Thread newT = new Thread(null, r, THREAD_NAME);
            newT.setPriority(5);
            newT.setDaemon(true);
            return newT;
        }
    });
    private final Monitor.CloseableLock monitorLock = Monitor.newDefaultLock();

    private FailoverManagerImpl(NonTxnReplayableBase connProxy, OracleDataSource rds) throws SQLException {
        this.connectionProxy = connProxy;
        this.replayDataSource = rds;
        this.enableTxnMonitoring((OracleConnection)this.connectionProxy.getDelegate());
    }

    static FailoverManager getFailoverManager(NonTxnReplayableBase connProxy, OracleDataSource rds) throws SQLException {
        return new FailoverManagerImpl(connProxy, rds);
    }

    private void append(CallHistoryEntry entry) {
        entry.prevEntry = this.tail;
        entry.nextEntry = null;
        if (this.tail != null) {
            this.tail.nextEntry = entry;
        }
        this.tail = entry;
        if (this.head == null) {
            this.head = entry;
        }
        Replayable jdbcProxy = (Replayable)entry.jdbcProxy;
        jdbcProxy.addToSameProxyList(entry);
    }

    private void remove(CallHistoryEntry entry) {
        if (entry.nextEntry != null) {
            entry.nextEntry.prevEntry = entry.prevEntry;
        }
        if (entry.prevEntry != null) {
            entry.prevEntry.nextEntry = entry.nextEntry;
        }
        if (this.head == entry) {
            this.head = entry.nextEntry;
        }
        if (this.tail == entry) {
            this.tail = entry.prevEntry;
        }
        Replayable jdbcProxy = (Replayable)entry.jdbcProxy;
        jdbcProxy.removeFromSameProxyList(entry);
    }

    CallHistoryEntry record(Object jdbcProxy, Method m, Object[] args, String callStatus) {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            String methodName = m == null ? "NULL METHOD" : m.getName();
            StringBuilder argStr = new StringBuilder();
            if (args != null && args.length > 0) {
                for (int i = 0; i < args.length - 1; ++i) {
                    argStr.append(args[i]);
                    argStr.append(",");
                }
                argStr.append(args[args.length - 1]);
            }
            this.debug(Level.FINEST, SecurityLabel.UNKNOWN, "oracle/jdbc/replay/driver/FailoverManagerImpl", "record", "On connection {0}, recording method {1}({2})", (String)null, (Throwable)null, new Object[]{this.connectionProxy, methodName, argStr.toString()});
            CallHistoryEntry entry = new CallHistoryEntry(jdbcProxy, m, args, callStatus);
            this.append(entry);
            this.debug(Level.FINEST, SecurityLabel.UNKNOWN, "oracle/jdbc/replay/driver/FailoverManagerImpl", "record", "On connection {0}, recorded method {1}", (String)null, (Throwable)null, new Object[]{this.connectionProxy, methodName});
            CallHistoryEntry callHistoryEntry = entry;
            return callHistoryEntry;
        }
    }

    void update(Object jdbcProxy, CallHistoryEntry e, Object result, String callStatus, long checksum, long SCN, SQLException sqlexc) {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            CallHistoryEntry entry = e == null ? this.tail : e;
            String methodName = entry == null || entry.method == null ? "NULL METHOD" : entry.method.getName();
            this.debug(Level.FINEST, SecurityLabel.UNKNOWN, "oracle/jdbc/replay/driver/FailoverManagerImpl", "update", "On connection {0}, updating entry for method {1}", (String)null, (Throwable)null, new Object[]{this.connectionProxy, methodName});
            entry.result = result;
            entry.checksum = checksum;
            entry.scn = SCN;
            entry.callException = sqlexc;
            entry.callStatus = callStatus;
            this.debug(Level.FINEST, SecurityLabel.UNKNOWN, "oracle/jdbc/replay/driver/FailoverManagerImpl", "update", "On connection {0}, updated entry for method {1} - result: {2}, checksum: {3}, SCN: {4}, SQLException: {5}", (String)null, (Throwable)null, new Object[]{this.connectionProxy, methodName, result, checksum, SCN, sqlexc});
        }
    }

    void purge() {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            this.debug(Level.FINER, SecurityLabel.UNKNOWN, "oracle/jdbc/replay/driver/FailoverManagerImpl", "purge", "On connection {0}, calling explicit purge", (String)null, (Throwable)null, (Object)this.connectionProxy);
            CallHistoryEntry entry = this.head;
            while (entry != null) {
                this.remove(entry);
                entry = entry.nextEntry;
            }
            this.debug(Level.FINER, SecurityLabel.UNKNOWN, "oracle/jdbc/replay/driver/FailoverManagerImpl", "purge", "On connection {0}, calling explicit purge succeeds", (String)null, (Throwable)null, (Object)this.connectionProxy);
        }
    }

    void purgeForSameProxy(Set<Object> visitedProxies, CallHistoryEntry headForProxy) {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            Object jproxy = headForProxy == null ? null : headForProxy.jdbcProxy;
            this.debug(Level.FINER, SecurityLabel.UNKNOWN, "oracle/jdbc/replay/driver/FailoverManagerImpl", "purgeForSameProxy", "On connection {0}, calling implicit purge for {1}", (String)null, (Throwable)null, new Object[]{this.connectionProxy, jproxy});
            CallHistoryEntry entry = headForProxy;
            while (entry != null) {
                Object callResult = entry.result;
                if (callResult != null && callResult instanceof Replayable && !visitedProxies.contains(callResult)) {
                    Replayable resultProxy = (Replayable)callResult;
                    resultProxy.purgeSameProxyList();
                    visitedProxies.add(resultProxy);
                }
                this.debug(Level.FINEST, SecurityLabel.UNKNOWN, "oracle/jdbc/replay/driver/FailoverManagerImpl", "purgeForSameProxy", "On connection {0}, implicit purge {1}", (String)null, (Throwable)null, new Object[]{this.connectionProxy, entry.method});
                this.remove(entry);
                entry = entry.nextEntrySameProxy;
            }
            this.debug(Level.FINER, SecurityLabel.UNKNOWN, "oracle/jdbc/replay/driver/FailoverManagerImpl", "purgeForSameProxy", "On connection {0}, calling implicit purge for {1} succeeds", (String)null, (Throwable)null, new Object[]{this.connectionProxy, jproxy});
        }
    }

    boolean isEmpty() {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            boolean bl = this.head == null;
            return bl;
        }
    }

    void fillInAllChecksums() throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            HashSet<Object> visitedProxies = new HashSet<Object>();
            CallHistoryEntry entry = this.tail.prevEntry;
            while (entry != null) {
                if (!visitedProxies.contains(entry.jdbcProxy)) {
                    NonTxnReplayableBase jproxy = (NonTxnReplayableBase)entry.jdbcProxy;
                    jproxy.fillInChecksum(entry);
                    visitedProxies.add(entry.jdbcProxy);
                    if (entry.jdbcProxy instanceof ResultSet) {
                        visitedProxies.add(jproxy.getCreator());
                    }
                }
                entry = entry.prevEntry;
            }
        }
    }

    /*
     * Exception decompiling
     */
    Object replayAll(SQLRecoverableException origError) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [16[CATCHBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    Object replayAllInternal(SQLRecoverableException origError, int currentRetries) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            OracleConnection newConn;
            this.debug(Level.FINER, SecurityLabel.UNKNOWN, "oracle/jdbc/replay/driver/FailoverManagerImpl", "replayAllInternal", "Entering replayAllInternal(connection proxy={0}, original error={1})", (String)null, (Throwable)null, new Object[]{this.connectionProxy, origError});
            ReplayLifecycle curLifecycle = this.lifecycle;
            this.debug(Level.FINEST, SecurityLabel.UNKNOWN, "oracle/jdbc/replay/driver/FailoverManagerImpl", "replayAllInternal", "current lifecycle:{0}", (String)null, (Throwable)null, (Object)curLifecycle);
            if (this.lifecycle != ReplayLifecycle.ENABLED_NOT_REPLAYING && this.lifecycle != ReplayLifecycle.REPLAYING && this.lifecycle != ReplayLifecycle.REPLAYING_LASTCALL && this.lifecycle != ReplayLifecycle.REPLAYING_CALLBACK) {
                this.throwReplayExceptionInternal(this.replayErrorCode, this.replayErrorMessage, origError);
            }
            if ((newConn = (OracleConnection)this.replayDataSource.getConnectionNoProxy(((NonTxnReplayableConnection)this.connectionProxy).originalConnectionBuilder)) == null) {
                this.debug(Level.FINE, SecurityLabel.UNKNOWN, "oracle/jdbc/replay/driver/FailoverManagerImpl", "replayAllInternal", "FAILOVER_RETRIES exceeded", null, null);
                this.disableReplayAndThrowException(null, 382, "Replay disabled because Failover_Retries is exceeded", origError);
            }
            this.debug(Level.FINER, SecurityLabel.UNKNOWN, "oracle/jdbc/replay/driver/FailoverManagerImpl", "replayAllInternal", "Reconnect succeeded, new connection={0}", (String)null, (Throwable)null, (Object)newConn);
            long currentTimestamp = System.currentTimeMillis();
            this.debug(Level.FINEST, SecurityLabel.UNKNOWN, "oracle/jdbc/replay/driver/FailoverManagerImpl", "replayAllInternal", "timestamp at replay start: {0}", (String)null, (Throwable)null, (Object)currentTimestamp);
            if (this.requestStartTime + this.replayInitiationTimeout * 1000L < currentTimestamp) {
                this.debug(Level.WARNING, SecurityLabel.UNKNOWN, "oracle/jdbc/replay/driver/FailoverManagerImpl", "replayAllInternal", "ReplayInitiationTimeout exceeded", null, null);
                this.disableReplayAndThrowException(null, 377, "Replay disabled because ReplayInitiationTimeout is exceeded", origError);
            }
            this.connectionProxy.setDelegate(newConn);
            newConn.setChecksumMode(OracleConnection.ChecksumMode.CALCULATE_CHECKSUM_ALL);
            this.lifecycle = ReplayLifecycle.REPLAYING_CALLBACK;
            ConnectionInitializationCallback initCbk = this.replayDataSource.getConnectionInitializationCallback();
            if (initCbk != null) {
                try {
                    this.debug(Level.FINER, SecurityLabel.UNKNOWN, "oracle/jdbc/replay/driver/FailoverManagerImpl", "replayAllInternal", "Invoking Replay Driver initialization callback with {0}", (String)null, (Throwable)null, (Object)this.connectionProxy);
                    initCbk.initialize((Connection)((Object)this.connectionProxy));
                    this.debug(Level.FINER, SecurityLabel.UNKNOWN, "oracle/jdbc/replay/driver/FailoverManagerImpl", "replayAllInternal", "Invoking initialization callback with {0} succeeded", (String)null, (Throwable)null, (Object)this.connectionProxy);
                }
                catch (SQLException sqlexc) {
                    this.debug(Level.FINER, SecurityLabel.UNKNOWN, "oracle/jdbc/replay/driver/FailoverManagerImpl", "replayAllInternal", "Invoking initialization callback with {0} failed", (String)null, (Throwable)null, (Object)this.connectionProxy);
                    this.disableReplayAndThrowException(null, 379, "Replay disabled because Init callback failed", origError);
                }
                EnumSet<OracleConnection.TransactionState> eocs = newConn.getTransactionState();
                this.debug(Level.FINER, SecurityLabel.UNKNOWN, "oracle/jdbc/replay/driver/FailoverManagerImpl", "replayAllInternal", "On connection {0}, after init-callback, transaction state={1}", (String)null, (Throwable)null, new Object[]{this.connectionProxy, eocs});
                if (eocs.contains((Object)OracleConnection.TransactionState.TRANSACTION_STARTED)) {
                    this.disableReplayAndThrowException(null, 380, "Replay disabled because of open transaction in Init callback", origError);
                }
            }
            this.lifecycle = ReplayLifecycle.REPLAYING;
            if (currentRetries == 0) {
                this.fillInAllChecksums();
            }
            this.beginReplay(newConn, origError);
            this.replayResult = this.replayAllBeforeLastCall(origError);
            this.endReplay(newConn, origError);
            this.debug(Level.FINEST, SecurityLabel.UNKNOWN, "oracle/jdbc/replay/driver/FailoverManagerImpl", "replayAllInternal", "On connection {0}, replaying last call", (String)null, (Throwable)null, (Object)this.connectionProxy);
            if (this.tail != null) {
                this.replayResult = ((Replayable)this.tail.jdbcProxy).replayOneCall(this.tail, origError);
            }
            this.lifecycle = ReplayLifecycle.ENABLED_NOT_REPLAYING;
            this.debug(Level.FINER, SecurityLabel.UNKNOWN, "oracle/jdbc/replay/driver/FailoverManagerImpl", "replayAllInternal", "On connection {0}, replay succeeds", (String)null, (Throwable)null, (Object)this.connectionProxy);
            this.debug(Level.FINER, SecurityLabel.UNKNOWN, "oracle/jdbc/replay/driver/FailoverManagerImpl", "replayAllInternal", "Exiting replayAll(connection proxy={0}, original error={1}), result={2}", (String)null, (Throwable)null, new Object[]{this.connectionProxy, origError, this.replayResult});
            Object object = this.replayResult;
            return object;
        }
    }

    private Object replayAllBeforeLastCall(SQLRecoverableException origError) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            Object replayResult = null;
            CallHistoryEntry entry = this.head;
            while (entry != this.tail) {
                Replayable jproxy = (Replayable)entry.jdbcProxy;
                this.debug(Level.FINEST, SecurityLabel.UNKNOWN, "oracle/jdbc/replay/driver/FailoverManagerImpl", "replayAllBeforeLastCall", "On proxy {0}, replaying {1}", (String)null, (Throwable)null, new Object[]{jproxy, entry.method});
                replayResult = jproxy.replayOneCall(entry, origError);
                if (this.lifecycle != ReplayLifecycle.ENABLED_NOT_REPLAYING && this.lifecycle != ReplayLifecycle.REPLAYING && this.lifecycle != ReplayLifecycle.REPLAYING_LASTCALL && this.lifecycle != ReplayLifecycle.REPLAYING_CALLBACK) {
                    this.throwReplayExceptionInternal(this.replayErrorCode, this.replayErrorMessage, origError);
                }
                entry = entry.nextEntry;
            }
            Object object = replayResult;
            return object;
        }
    }

    boolean isReplayInCurrentMode() {
        return this.replayInCurrentMode;
    }

    void setReplayInCurrentMode() {
        this.replayInCurrentMode = true;
    }

    ReplayLifecycle getReplayLifecycle() {
        return this.lifecycle;
    }

    void setDataSource(OracleDataSource rds) {
        this.replayDataSource = rds;
    }

    void setReplayInitiationTimeout(int timeout) throws SQLException {
        this.replayInitiationTimeout = timeout;
    }

    void beginRequest() throws SQLException {
        this.debug(Level.FINER, SecurityLabel.UNKNOWN, "oracle/jdbc/replay/driver/FailoverManagerImpl", "beginRequest", "On connection {0}, Entering beginRequest()", (String)null, (Throwable)null, (Object)this.connectionProxy);
        if (this.lifecycle == ReplayLifecycle.ALWAYS_DISABLED) {
            this.debug(Level.FINER, SecurityLabel.UNKNOWN, "oracle/jdbc/replay/driver/FailoverManagerImpl", "beginRequest", "Exiting beginRequest(), MONITOR_TXN failed, no-op", null, null);
            return;
        }
        if (this.lifecycle != ReplayLifecycle.INTERNALLY_DISABLED) {
            throw DatabaseError.createSqlException(391);
        }
        this.requestStartTime = System.currentTimeMillis();
        this.debug(Level.FINEST, SecurityLabel.UNKNOWN, "oracle/jdbc/replay/driver/FailoverManagerImpl", "beginRequest", "Request start timestamp: {0}", (String)null, (Throwable)null, (Object)this.requestStartTime);
        OracleConnection oconn = (OracleConnection)this.connectionProxy.getDelegate();
        EnumSet<OracleConnection.TransactionState> eocs = oconn.getTransactionState();
        this.debug(Level.FINER, SecurityLabel.UNKNOWN, "oracle/jdbc/replay/driver/FailoverManagerImpl", "beginRequest", "transaction state: {0}", (String)null, (Throwable)null, (Object)eocs);
        if (eocs.contains((Object)OracleConnection.TransactionState.TRANSACTION_STARTED) && !eocs.contains((Object)OracleConnection.TransactionState.TRANSACTION_READONLY)) {
            SQLException sqlexc = DatabaseError.createSqlException(392);
            this.debug(Level.FINER, SecurityLabel.UNKNOWN, "oracle/jdbc/replay/driver/FailoverManagerImpl", "beginRequest", "beginRequest", null, sqlexc);
            throw sqlexc;
        }
        this.replayErrorCode = 0;
        this.replayErrorMessage = "";
        this.callCausingReplayError = null;
        oconn.setChecksumMode(OracleConnection.ChecksumMode.CALCULATE_CHECKSUM_ALL);
        this.lifecycle = ReplayLifecycle.ENABLED_NOT_REPLAYING;
        this.debug(Level.FINER, SecurityLabel.UNKNOWN, "oracle/jdbc/replay/driver/FailoverManagerImpl", "beginRequest", "Recording begins on connection {0}", (String)null, (Throwable)null, (Object)this.connectionProxy);
        this.debug(Level.FINER, SecurityLabel.UNKNOWN, "oracle/jdbc/replay/driver/FailoverManagerImpl", "beginRequest", "Exiting beginRequest()", null, null);
    }

    void endRequest() throws SQLException {
        this.debug(Level.FINER, SecurityLabel.UNKNOWN, "oracle/jdbc/replay/driver/FailoverManagerImpl", "endRequest", "Entering endRequest()", null, null);
        OracleConnection oconn = (OracleConnection)this.connectionProxy.getDelegate();
        EnumSet<OracleConnection.TransactionState> eocs = oconn.getTransactionState();
        this.debug(Level.FINER, SecurityLabel.UNKNOWN, "oracle/jdbc/replay/driver/FailoverManagerImpl", "endRequest", "transaction state: {0}", (String)null, (Throwable)null, (Object)eocs);
        if (eocs.contains((Object)OracleConnection.TransactionState.TRANSACTION_STARTED) && !eocs.contains((Object)OracleConnection.TransactionState.TRANSACTION_READONLY)) {
            try {
                oconn.rollback();
            }
            catch (SQLException sqlexc) {
                this.debug(Level.FINEST, SecurityLabel.UNKNOWN, "oracle/jdbc/replay/driver/FailoverManagerImpl", "endRequest", "Rollback open transaction failed before throwing exception", null, null);
            }
            SQLException sqlexc = DatabaseError.createSqlException(393);
            this.debug(Level.FINER, SecurityLabel.UNKNOWN, "oracle/jdbc/replay/driver/FailoverManagerImpl", "endRequest", "endRequest", null, sqlexc);
            throw sqlexc;
        }
        if (this.lifecycle == ReplayLifecycle.ALWAYS_DISABLED) {
            this.debug(Level.FINER, SecurityLabel.UNKNOWN, "oracle/jdbc/replay/driver/FailoverManagerImpl", "endRequest", "Exiting endRequest() -- MONITOR_TXN failed", null, null);
            return;
        }
        if (this.lifecycle == ReplayLifecycle.INTERNALLY_DISABLED || this.lifecycle == ReplayLifecycle.EXTERNALLY_DISABLED) {
            this.debug(Level.FINER, SecurityLabel.UNKNOWN, "oracle/jdbc/replay/driver/FailoverManagerImpl", "endRequest", "Exiting endRequest() -- replay already disabled", null, null);
            this.lifecycle = ReplayLifecycle.INTERNALLY_DISABLED;
            return;
        }
        this.disableReplayInternal(null, 381, "Replay disabled after endRequest is called", null);
        this.debug(Level.FINER, SecurityLabel.UNKNOWN, "oracle/jdbc/replay/driver/FailoverManagerImpl", "endRequest", "Exiting endRequest()", null, null);
    }

    void disableReplay() throws SQLException {
        this.debug(Level.FINER, SecurityLabel.UNKNOWN, "oracle/jdbc/replay/driver/FailoverManagerImpl", "disableReplay", "Entering disableReplay", null, null);
        if (this.lifecycle == ReplayLifecycle.ALWAYS_DISABLED) {
            this.debug(Level.FINER, SecurityLabel.UNKNOWN, "oracle/jdbc/replay/driver/FailoverManagerImpl", "disableReplay", "Exiting disableReplay(), MONITOR_TXN failed, no-op", null, null);
            return;
        }
        this.disableReplayInternal(null, 370, "Replay disabled", null);
        this.lifecycle = ReplayLifecycle.EXTERNALLY_DISABLED;
        this.debug(Level.FINER, SecurityLabel.UNKNOWN, "oracle/jdbc/replay/driver/FailoverManagerImpl", "disableReplay", "On connection {0}, replay is externally disabled", (String)null, (Throwable)null, (Object)this.connectionProxy);
        this.debug(Level.FINER, SecurityLabel.UNKNOWN, "oracle/jdbc/replay/driver/FailoverManagerImpl", "disableReplay", "Exiting disableReplay", null, null);
    }

    void disableReplayInternal(Method m, int errCode, String errMesg, SQLRecoverableException origError) {
        this.debug(Level.FINER, SecurityLabel.UNKNOWN, "oracle/jdbc/replay/driver/FailoverManagerImpl", "disableReplayInternal", "Entering disableReplayInternal", null, null);
        ReplayLifecycle curLifecycle = this.lifecycle;
        OracleConnection oconn = (OracleConnection)this.connectionProxy.getDelegate();
        if (this.lifecycle != ReplayLifecycle.ALWAYS_DISABLED) {
            this.lifecycle = ReplayLifecycle.INTERNALLY_DISABLED;
        }
        this.purge();
        this.replayErrorCode = errCode;
        this.replayErrorMessage = errMesg;
        this.callCausingReplayError = m;
        this.debug(Level.FINER, SecurityLabel.UNKNOWN, "oracle/jdbc/replay/driver/FailoverManagerImpl", "disableReplayInternal", "On connection {0}, replay is internally disabled", (String)null, (Throwable)null, (Object)this.connectionProxy);
        try {
            oconn.setChecksumMode(OracleConnection.ChecksumMode.NO_CHECKSUM);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        this.debug(Level.FINER, SecurityLabel.UNKNOWN, "oracle/jdbc/replay/driver/FailoverManagerImpl", "disableReplayInternal", "Exiting disableReplayInternal", null, null);
    }

    void failReplayInternal(Method m, int errCode, String errMesg, SQLRecoverableException origError) {
        this.debug(Level.FINER, SecurityLabel.UNKNOWN, "oracle/jdbc/replay/driver/FailoverManagerImpl", "failReplayInternal", "Entering failReplayInternal", null, null);
        ReplayLifecycle curLifecycle = this.lifecycle;
        if (this.lifecycle == ReplayLifecycle.REPLAYING || this.lifecycle == ReplayLifecycle.REPLAYING_CALLBACK || this.lifecycle == ReplayLifecycle.REPLAYING_LASTCALL) {
            this.lifecycle = ReplayLifecycle.INTERNALLY_FAILED;
        }
        this.replayErrorCode = errCode;
        this.replayErrorMessage = errMesg;
        this.callCausingReplayError = m;
        this.debug(Level.FINER, SecurityLabel.UNKNOWN, "oracle/jdbc/replay/driver/FailoverManagerImpl", "failReplayInternal", "On connection {0}, replay failed", (String)null, (Throwable)null, (Object)this.connectionProxy);
        this.debug(Level.FINER, SecurityLabel.UNKNOWN, "oracle/jdbc/replay/driver/FailoverManagerImpl", "failReplayInternal", "Exiting failReplayInternal", null, null);
    }

    void throwReplayExceptionInternal(int errCode, String errMesg, SQLRecoverableException origError) throws SQLException {
        if (errCode == 0) {
            return;
        }
        String callNameCausingException = this.callCausingReplayError == null ? "" : this.callCausingReplayError.getName();
        SQLException replayErr = DatabaseError.createSqlException(this.replayErrorCode, callNameCausingException);
        throw replayErr;
    }

    void disableReplayAndThrowException(Method m, int errCode, String errMesg, SQLRecoverableException origError) throws SQLException {
        this.disableReplayInternal(m, errCode, errMesg, origError);
        this.throwReplayExceptionInternal(errCode, errMesg, origError);
    }

    void disableReplayAndThrowOriginalError(Method m, int errCode, String errMesg, SQLRecoverableException origError) throws SQLException {
        this.disableReplayInternal(m, errCode, errMesg, origError);
        this.throwOriginalExceptionWithReplayError(errCode, errMesg, origError);
    }

    void failReplayAndThrowException(Method m, int errCode, String errMesg, SQLRecoverableException origError) throws SQLException {
        this.failReplayInternal(m, errCode, errMesg, origError);
        this.throwReplayExceptionInternal(errCode, errMesg, origError);
    }

    void throwOriginalExceptionWithReplayError(int errCode, String errMesg, SQLRecoverableException origError) throws SQLRecoverableException {
        this.killConnectionBeforeReplayDisabledException();
        String callNameCausingException = this.callCausingReplayError == null ? "" : this.callCausingReplayError.getName();
        SQLException replayErr = DatabaseError.createSqlException(this.replayErrorCode, callNameCausingException);
        origError.setNextException(replayErr);
        throw origError;
    }

    void killConnectionBeforeReplayDisabledException() {
        final OracleConnection oconn = (OracleConnection)this.connectionProxy.getDelegate();
        try {
            oconn.abort();
        }
        catch (SQLException sqlexc) {
            this.debug(Level.FINE, SecurityLabel.UNKNOWN, "oracle/jdbc/replay/driver/FailoverManagerImpl", "killConnectionBeforeReplayDisabledException", "Aborting connection failed before throwing replay-disabled exception", null, null);
        }
        try {
            executor.submit(new Runnable(){

                @Override
                public void run() {
                    FailoverManagerImpl.this.closePhysicalConnection(oconn);
                }
            });
        }
        catch (Exception exc) {
            this.debug(Level.FINER, SecurityLabel.UNKNOWN, "oracle/jdbc/replay/driver/FailoverManagerImpl", "killConnectionBeforeReplayDisabledException", "On connection {0}, ASYNC close() submission during replay failed", (String)null, (Throwable)null, (Object)this.connectionProxy);
        }
    }

    void enableTxnMonitoring(OracleConnection oconn) throws SQLException {
        try {
            Statement stmt = oconn.createStatement();
            this.debug(Level.FINER, SecurityLabel.UNKNOWN, "oracle/jdbc/replay/driver/FailoverManagerImpl", "enableTxnMonitoring", "Calling MONITOR_TXN", null, null);
            stmt.execute(MONITOR_TXN);
            this.debug(Level.FINER, SecurityLabel.UNKNOWN, "oracle/jdbc/replay/driver/FailoverManagerImpl", "enableTxnMonitoring", "Calling MONITOR_TXN succeeded", null, null);
            stmt.close();
        }
        catch (SQLException sqlexc) {
            this.debug(Level.FINER, SecurityLabel.UNKNOWN, "oracle/jdbc/replay/driver/FailoverManagerImpl", "enableTxnMonitoring", "Calling MONITOR_TXN failed", null, null);
            this.disableReplayInternal(null, 374, "Replay disabled because transaction monitoring failed to be enabled", null);
            this.lifecycle = ReplayLifecycle.ALWAYS_DISABLED;
            throw DatabaseError.createSqlException(395);
        }
    }

    void beginReplay(OracleConnection oconn, SQLRecoverableException origError) throws SQLException {
        try {
            Statement stmt = oconn.createStatement();
            this.debug(Level.FINER, SecurityLabel.UNKNOWN, "oracle/jdbc/replay/driver/FailoverManagerImpl", "beginReplay", "Calling BEGIN_REPLAY", null, null);
            stmt.execute(BEGIN_REPLAY);
            this.debug(Level.FINER, SecurityLabel.UNKNOWN, "oracle/jdbc/replay/driver/FailoverManagerImpl", "beginReplay", "Calling BEGIN_REPLAY succeeded", null, null);
            stmt.close();
            this.lifecycle = ReplayLifecycle.REPLAYING;
        }
        catch (SQLException sqlexc) {
            this.debug(Level.FINER, SecurityLabel.UNKNOWN, "oracle/jdbc/replay/driver/FailoverManagerImpl", "beginReplay", "Calling BEGIN_REPLAY failed", null, null);
            this.disableReplayAndThrowException(null, 375, "Replay disabled because server begin_replay call failed", origError);
        }
    }

    void endReplay(OracleConnection oconn, SQLRecoverableException origError) throws SQLException {
        try {
            Statement stmt = oconn.createStatement();
            this.debug(Level.FINER, SecurityLabel.UNKNOWN, "oracle/jdbc/replay/driver/FailoverManagerImpl", "endReplay", "Calling END_REPLAY", null, null);
            stmt.execute(END_REPLAY);
            this.debug(Level.FINER, SecurityLabel.UNKNOWN, "oracle/jdbc/replay/driver/FailoverManagerImpl", "endReplay", "Calling END_REPLAY succeeded", null, null);
            stmt.close();
            this.lifecycle = ReplayLifecycle.REPLAYING_LASTCALL;
        }
        catch (SQLException sqlexc) {
            this.debug(Level.FINER, SecurityLabel.UNKNOWN, "oracle/jdbc/replay/driver/FailoverManagerImpl", "endReplay", "Calling END_REPLAY failed", null, null);
            this.disableReplayAndThrowException(null, 376, "Replay disabled because server end_replay call failed", origError);
        }
    }

    Replayable getConnectionProxy() {
        return this.connectionProxy;
    }

    private boolean isReplayFailure(SQLException t) {
        int errCode;
        boolean result = false;
        if (t != null && (errCode = t.getErrorCode()) >= 370 && errCode < 400) {
            result = true;
        }
        return result;
    }

    private void closePhysicalConnection(Connection conn) {
        try {
            conn.close();
        }
        catch (SQLException sqlexc) {
            this.debug(Level.FINER, SecurityLabel.UNKNOWN, "oracle/jdbc/replay/driver/FailoverManagerImpl", "closePhysicalConnection", "On connection {0}, connection close() during replay failed", (String)null, (Throwable)null, (Object)this.connectionProxy);
        }
    }

    @Override
    public final Monitor.CloseableLock getMonitorLock() {
        return this.monitorLock;
    }

    @Override
    public Diagnosable getDiagnosable() {
        return CommonDiagnosable.getInstance();
    }

    static enum ReplayLifecycle {
        ENABLED_NOT_REPLAYING,
        INTERNALLY_FAILED,
        INTERNALLY_DISABLED,
        ALWAYS_DISABLED,
        EXTERNALLY_DISABLED,
        REPLAYING_CALLBACK,
        REPLAYING,
        REPLAYING_LASTCALL;

    }

    static class CallHistoryEntry {
        Object jdbcProxy;
        Method method;
        Object[] args;
        Object result;
        String callStatus;
        long scn;
        long checksum;
        SQLException callException;
        CallHistoryEntry nextEntry = null;
        CallHistoryEntry prevEntry = null;
        CallHistoryEntry nextEntrySameProxy = null;
        CallHistoryEntry prevEntrySameProxy = null;

        CallHistoryEntry(Object jdbcProxy, Method m, Object[] args, String callStatus) {
            this.jdbcProxy = jdbcProxy;
            this.method = m;
            this.args = args;
            this.result = null;
            this.callStatus = callStatus;
        }
    }
}

