/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.o5logon;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;
import oracle.jdbc.diagnostics.Diagnosable;
import oracle.jdbc.diagnostics.Metrics;
import oracle.jdbc.internal.Monitor;
import oracle.jdbc.internal.OracleConnection;
import oracle.net.aso.AESEncryption;
import oracle.net.aso.AsoException;
import oracle.security.o3logon.O3LoginProtocolHelper;

public final class O5Logon
implements Diagnosable {
    private static final int ZTV_LEN_CRYPT = 13;
    private static final int ZTV_LEN_MD5CRYPT = 34;
    private static final int ZTV_LEN_NTV = 32;
    private static final int ZTV_LEN_LMV = 32;
    private static final int ZTV_LEN_ORCL = 16;
    private static final int ZTV_MAX_SALTL = 16;
    private static final int ZTVGCRM_MAX_SALTL = 8;
    private static final String ZTVGCRM_MAGIC = "$1$";
    private static final int ZTVGCRM_MAGIC_LEN = 3;
    private static final int ZTVT_UNKNOWN = 0;
    private static final int ZTVT_NO_TAG = 48813;
    private static final int ZTVT_MD5 = 40674;
    private static final int ZTVT_MD4 = 23322;
    private static final int ZTVT_SH1 = 45394;
    private static final int ZTVT_SHA512 = 18453;
    private static final int ZTVT_SMD5 = 59694;
    private static final int ZTVT_SMD4 = 5547;
    private static final int ZTVT_SSH1 = 6949;
    private static final int ZTVT_SASLMD5 = 13108;
    private static final int ZTVT_SASLDAV = 42044;
    private static final int ZTVT_ORCL_7 = 2361;
    private static final int ZTVT_ORCL_E = 40555;
    private static final int ZTVT_ORCL_C = 33149;
    private static final int ZTVT_CRYPT = 28613;
    private static final int ZTVT_NTV = 7809;
    private static final int ZTVT_LMV = 61771;
    private static final int ZTVOKNONE = 0;
    private static final int ZTVOKDES = 40298;
    private static final int ZTVOKDES2 = 922;
    private static final int ZTVOKO5AES128 = 4198;
    private static final int ZTVOKO5AES192 = 5266;
    private static final int ZTVOKO5AES256 = 4077;
    private static final int ZTVOKO5AES128NP = 39996;
    private static final int ZTVOKO5AES192NP = 54439;
    private static final int ZTVOKO5AES256NP = 4444;
    private static final int ZTVOV_KPCLOG_O3L = 1;
    private static final int ZTVOV_KPCLOG_O5L_NP = 2;
    private static final int ZTVOV_KPCLOG_O4L = 4;
    private static final int ZTVOV_KPCLOG_O5L = 8;
    private static final int ZTVOV_KPCLOG_O6L = 16;
    private static final int FIXED_RESPONSE_LENGTH = 16;
    private final byte AUTH_ORA_DEBUG_JDWP_ENC_SESSION = 1;
    public static final int AUTH_FLAG_SHA2 = 1;
    private static final char[] HEX = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private final OracleConnection connection;
    boolean use_O7L_MR;
    boolean useJCEAPI = false;
    private int genPKCounter = 0;
    private final Diagnosable diagnosable;
    private static final SecureRandom SECURE_RANDOM = O5Logon.getSecureRandom();
    private static final Monitor RANDOM_LOCK = Monitor.newInstance();
    private final MessageDigest md5Digest = this.getMD5Digest();
    private final MessageDigest sha1Digest = this.getSHA1Digest();
    private final MessageDigest sha512Digest = this.getSHA512Digest();
    private byte[] o5logonKey = null;
    private String sessKeyStr = null;
    private String pwdEncStr = null;
    private String pkEncStr = null;

    public O5Logon(OracleConnection conn, boolean logonCapability_O7L_MR, boolean useJCEAPI, Diagnosable diagnosable) {
        this.connection = conn;
        this.use_O7L_MR = logonCapability_O7L_MR;
        this.useJCEAPI = useJCEAPI;
        this.diagnosable = diagnosable;
    }

    private static final SecureRandom getSecureRandom() {
        SecureRandom random = null;
        try {
            random = new SecureRandom();
            byte[] dummy = new byte[32];
            random.nextBytes(dummy);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return random;
    }

    private static final void generateRandomBytes(byte[] bytes) {
        try (Monitor.CloseableLock lock = RANDOM_LOCK.acquireCloseableLock();){
            SECURE_RANDOM.nextBytes(bytes);
        }
    }

    private final MessageDigest getMD5Digest() {
        MessageDigest digest = null;
        try {
            digest = MessageDigest.getInstance("MD5");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return digest;
    }

    private final MessageDigest getSHA1Digest() {
        MessageDigest digest = null;
        try {
            digest = MessageDigest.getInstance("SHA1");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return digest;
    }

    private final MessageDigest getSHA512Digest() {
        MessageDigest digest = null;
        try {
            digest = MessageDigest.getInstance("SHA-512");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return digest;
    }

    public static boolean isOL7MRCapable() {
        try {
            O5Logon.getPBKDF2WithSHA512();
            return true;
        }
        catch (NoSuchAlgorithmException e) {
            return false;
        }
    }

    private final byte[] buildO5LogonKey(int verifier, byte[] ka, int start1, byte[] kb, int start2, int sha512_PBKDF2SderCount, byte[] sha512_saltPBKDF2Nibbles) throws Exception {
        byte[] ret = null;
        byte[] buf = null;
        int keyLen = 0;
        if (this.use_O7L_MR) {
            switch (verifier) {
                case 2361: 
                case 40674: 
                case 59694: {
                    keyLen = 16;
                    break;
                }
                case 6949: 
                case 45394: {
                    keyLen = 24;
                    break;
                }
                case 18453: {
                    keyLen = 32;
                }
            }
            int iterations = sha512_PBKDF2SderCount;
            byte[] kbka = new byte[2 * keyLen];
            System.arraycopy(kb, 0, kbka, 0, keyLen);
            System.arraycopy(ka, 0, kbka, keyLen, keyLen);
            byte[] kakbNibbles = new byte[kbka.length * 2];
            this.bArray2Nibbles(kbka, kakbNibbles);
            byte[] saltBinary = this.toBinArray(new String(sha512_saltPBKDF2Nibbles, "US-ASCII"));
            PBEKeySpec pbkdf2key = new PBEKeySpec(new String(kakbNibbles, "US-ASCII").toCharArray(), saltBinary, iterations, keyLen * 8);
            SecretKeyFactory factory = O5Logon.getPBKDF2WithSHA512();
            ret = this.generateCheckedKey(pbkdf2key, factory);
        } else {
            switch (verifier) {
                case 2361: 
                case 40674: 
                case 59694: {
                    keyLen = 16;
                    buf = new byte[keyLen];
                    for (int i = 0; i < keyLen; ++i) {
                        buf[i] = (byte)(ka[i + start1] ^ kb[i + start2]);
                    }
                    this.md5Digest.reset();
                    ret = this.md5Digest.digest(buf);
                    break;
                }
                case 6949: 
                case 45394: {
                    keyLen = 24;
                    buf = new byte[keyLen];
                    for (int i = 0; i < keyLen; ++i) {
                        buf[i] = (byte)(ka[i + start1] ^ kb[i + start2]);
                    }
                    ret = new byte[keyLen];
                    this.md5Digest.reset();
                    this.md5Digest.update(buf, 0, 16);
                    byte[] tmpbuf = this.md5Digest.digest();
                    System.arraycopy(tmpbuf, 0, ret, 0, 16);
                    this.md5Digest.reset();
                    this.md5Digest.update(buf, 16, 8);
                    tmpbuf = this.md5Digest.digest();
                    System.arraycopy(tmpbuf, 0, ret, 16, 8);
                    break;
                }
                case 18453: {
                    keyLen = 32;
                    buf = new byte[keyLen];
                    for (int i = 0; i < keyLen; ++i) {
                        buf[i] = (byte)(ka[i + start1] ^ kb[i + start2]);
                    }
                    ret = new byte[keyLen];
                    this.md5Digest.reset();
                    this.md5Digest.update(buf, 0, 16);
                    byte[] tmpbuf1 = this.md5Digest.digest();
                    System.arraycopy(tmpbuf1, 0, ret, 0, 16);
                    this.md5Digest.reset();
                    this.md5Digest.update(buf, 16, 16);
                    tmpbuf1 = this.md5Digest.digest();
                    System.arraycopy(tmpbuf1, 0, ret, 16, 16);
                    break;
                }
                default: {
                    ret = new byte[]{};
                }
            }
        }
        return ret;
    }

    public byte[] getO5LogonKey() {
        return this.o5logonKey;
    }

    public byte[] getDerivedKey(byte[] dhKey, int mode) throws NoSuchAlgorithmException, InvalidKeySpecException {
        byte[] secretKey = null;
        String secretKeyHex = null;
        String algorithm = "PBKDF2WithHmacSHA512";
        int keyLength = 512;
        secretKey = this.o5logonKey;
        if ((mode & 1) != 1) {
            algorithm = "PBKDF2WithHmacSHA1";
            keyLength = 160;
        }
        StringBuffer hexBuffer = new StringBuffer(secretKey.length * 2);
        for (int i = 0; i < secretKey.length; ++i) {
            for (int j = 1; j >= 0; --j) {
                hexBuffer.append(HEX[secretKey[i] >> j * 4 & 0xF]);
            }
        }
        secretKeyHex = hexBuffer.toString();
        PBEKeySpec password = new PBEKeySpec(secretKeyHex.toCharArray(), dhKey, 1000, keyLength);
        SecretKeyFactory factory = SecretKeyFactory.getInstance(algorithm);
        try {
            byte[] encoded = this.generateCheckedKey(password, factory);
            SecretKeySpec encKey = new SecretKeySpec(encoded, "AES");
            return (byte[])encKey.getEncoded().clone();
        }
        catch (Exception e) {
            throw (InvalidKeySpecException)new InvalidKeySpecException().initCause(e);
        }
    }

    public boolean validateServerIdentity(String msgHex) {
        boolean ret = false;
        try {
            byte[] decryptedBytes = this.decryptAESWithO5logonKey(msgHex, this.pwdEncStr);
            String compareWithString = new String(decryptedBytes, 16, decryptedBytes.length - 16, "US-ASCII");
            ret = compareWithString.compareTo("SERVER_TO_CLIENT") == 0;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ret;
    }

    private final byte[] decryptAESWithO5logonKey(String msgHex, String decStr) throws AsoException {
        return this.decryptAES(this.o5logonKey, msgHex, decStr);
    }

    private final byte[] decryptAES(byte[] key, String msgHex, String decStr) throws AsoException {
        if (key == null) {
            return new byte[0];
        }
        byte[] iv = new byte[16];
        for (int i = 0; i < iv.length; ++i) {
            iv[0] = 0;
        }
        byte[] ret = new byte[]{};
        byte[] abar = this.toBinArray(msgHex);
        int aesMode = key.length == 16 ? 1 : (key.length == 24 ? 2 : 3);
        int aesPadding = decStr.endsWith("PKCS5Padding") ? 2 : 0;
        AESEncryption aes = new AESEncryption(1, aesMode, aesPadding, true);
        aes.init(key, iv);
        ret = aes.decrypt(abar);
        return ret;
    }

    private final byte[] encryptAESWithO5logonKey(byte[] msg, String encStr) throws AsoException {
        return this.encryptAES(this.o5logonKey, msg, encStr);
    }

    private final byte[] encryptAES(byte[] key, byte[] msg, String encStr) throws AsoException {
        if (key == null) {
            return new byte[0];
        }
        byte[] iv = new byte[16];
        for (int i = 0; i < iv.length; ++i) {
            iv[0] = 0;
        }
        byte[] ret = new byte[]{};
        int aesMode = key.length == 16 ? 1 : (key.length == 24 ? 2 : 3);
        int aesPadding = encStr.endsWith("PKCS5Padding") ? 2 : (encStr.endsWith("Zeros") ? 3 : 0);
        AESEncryption aes = new AESEncryption(1, aesMode, aesPadding, true);
        aes.init(key, iv);
        ret = aes.encrypt(msg);
        return ret;
    }

    public void generateOAuthResponse(int verifierType, byte[] salt, String noQuotesUser, String noQuotesPwd, String noQuotesNewPwd, byte[] noQuotesPwdNetBytes, byte[] noQuotesNewPwdNetBytes, byte[] encryptedKANibbles, byte[] encryptedKBNibbles, byte[] encryptedPasswordNibbles, byte[] encryptedNewPasswordNibbles, int[] encryptedPasswordNibblesLength, int[] encryptedNewPasswordNibblesLength, boolean svrCSMultibyte, byte ologonServerCapabilities, byte[] saltPBKDF2Nibbles, int PBKDF2VgenCount, int PBKDF2SderCount, byte[] pkEncryptedNibbles, int[] pkEncryptedNibblesLength) throws Exception {
        byte[] verifier = null;
        byte[] pk = null;
        int confounderLen = 16;
        if (SECURE_RANDOM == null || this.sha1Digest == null || this.md5Digest == null && !this.use_O7L_MR || !O5Logon.isOL7MRCapable() && this.use_O7L_MR || this.sha512Digest == null) {
            throw new Exception("Resource A missing.");
        }
        if (encryptedPasswordNibblesLength.length != 1) {
            throw new Exception("Resource B missing.");
        }
        if (verifierType == 18453) {
            pk = this.generatePk(PBKDF2VgenCount, noQuotesPwd, salt);
            verifier = this.constructVerifierForSHA512(pk, salt);
        } else {
            verifier = this.constructVerifierExceptSHA512(verifierType, noQuotesUser, noQuotesPwd, svrCSMultibyte, salt, ologonServerCapabilities);
        }
        byte[] ka = this.decryptAES(verifier, new String(encryptedKANibbles, "US-ASCII"), this.sessKeyStr);
        byte[] kb = this.generateKb(ka, verifier, encryptedKBNibbles, encryptedKANibbles);
        this.o5logonKey = this.buildO5LogonKey(verifierType, ka, 16, kb, 16, PBKDF2SderCount, saltPBKDF2Nibbles);
        this.generateSpeedKey(16, verifierType, pkEncryptedNibbles, pkEncryptedNibblesLength, pk);
        if (noQuotesNewPwdNetBytes != null) {
            this.encryptPassword(noQuotesNewPwdNetBytes, encryptedNewPasswordNibbles, 16, encryptedNewPasswordNibblesLength);
        }
        this.encryptPassword(noQuotesPwdNetBytes, encryptedPasswordNibbles, 16, encryptedPasswordNibblesLength);
    }

    public void generateOAuthResponse(int verifierType, byte[] salt, String noQuotesUser, String noQuotesPwd, byte[] noQuotesPwdNetBytes, byte[] encryptedKANibbles, byte[] encryptedKBNibbles, byte[] encryptedPasswordNibbles, int[] encryptedPasswordNibblesLength, boolean svrCSMultibyte, byte ologonServerCapabilities, byte[] saltPBKDF2Nibbles, int PBKDF2VgenCount, int PBKDF2SderCount, byte[] pkEncryptedNibbles, int[] pkEncryptedNibblesLength) throws Exception {
        this.generateOAuthResponse(verifierType, salt, noQuotesUser, noQuotesPwd, null, noQuotesPwdNetBytes, null, encryptedKANibbles, encryptedKBNibbles, encryptedPasswordNibbles, null, encryptedPasswordNibblesLength, null, svrCSMultibyte, ologonServerCapabilities, saltPBKDF2Nibbles, PBKDF2VgenCount, PBKDF2SderCount, pkEncryptedNibbles, pkEncryptedNibblesLength);
    }

    private byte[] constructVerifierForSHA512(byte[] pk, byte[] salt) throws Exception {
        this.sha512Digest.reset();
        this.sha512Digest.update(pk);
        if (salt != null) {
            this.sha512Digest.update(this.toBinArray(new String(salt, "US-ASCII")));
        }
        byte[] pkh = this.sha512Digest.digest();
        return pkh;
    }

    private byte[] constructVerifierExceptSHA512(int verifierType, String noQuotesUser, String noQuotesPwd, boolean svrCSMultibyte, byte[] salt, byte ologonServerCapabilities) throws Exception {
        byte[] verifier = null;
        if (verifierType == 2361) {
            this.sessKeyStr = "AES/CBC/NoPadding";
            this.pwdEncStr = "AES/CBC/PKCS5Padding";
            O3LoginProtocolHelper pHelper = new O3LoginProtocolHelper(this.useJCEAPI);
            byte[] verif8 = pHelper.getVerifier(noQuotesUser, noQuotesPwd, svrCSMultibyte);
            verifier = new byte[16];
            System.arraycopy(verif8, 0, verifier, 0, 8);
            for (int k = 8; k < 16; ++k) {
                verifier[k] = 0;
            }
        } else if (verifierType == 6949 || verifierType == 45394) {
            this.sessKeyStr = (ologonServerCapabilities & 2) != 0 ? "AES/CBC/NoPadding" : "AES/CBC/PKCS5Padding";
            this.pwdEncStr = "AES/CBC/PKCS5Padding";
            this.sha1Digest.reset();
            this.sha1Digest.update(noQuotesPwd.getBytes("UTF-8"));
            if (verifierType == 6949 && salt != null) {
                this.sha1Digest.update(this.toBinArray(new String(salt, "US-ASCII")));
            }
            byte[] sha1vfr = this.sha1Digest.digest();
            verifier = new byte[24];
            for (int i = 0; i < verifier.length; ++i) {
                verifier[i] = 0;
            }
            System.arraycopy(sha1vfr, 0, verifier, 0, sha1vfr.length);
        } else if (verifierType == 40674 || verifierType == 59694) {
            this.sessKeyStr = "AES/CBC/NoPadding";
            this.pwdEncStr = "AES/CBC/PKCS5Padding";
            this.md5Digest.reset();
            this.md5Digest.update(noQuotesPwd.getBytes("UTF-8"));
            if (verifierType == 59694) {
                this.md5Digest.update(this.toBinArray(new String(salt, "US-ASCII")));
            }
            verifier = this.md5Digest.digest();
        } else {
            throw new Exception("Resource C missing.");
        }
        return verifier;
    }

    private byte[] generatePk(int PBKDF2VgenCount, String noQuotesPwd, byte[] salt) throws Exception {
        this.sessKeyStr = "AES/CBC/NoPadding";
        this.pwdEncStr = "AES/CBC/PKCS5Padding";
        this.pkEncStr = "AES/CBC/NoPadding";
        int iterations = PBKDF2VgenCount;
        int pmkLength = 512;
        byte[] saltForPBKDF2Part1 = this.toBinArray(new String(salt, "US-ASCII"));
        String AUTH_PBKDF2_SPEEDY_KEY = "AUTH_PBKDF2_SPEEDY_KEY";
        byte[] saltForPBKDF2Part2 = "AUTH_PBKDF2_SPEEDY_KEY".getBytes("US-ASCII");
        byte[] saltForPBKDF2 = new byte[saltForPBKDF2Part1.length + saltForPBKDF2Part2.length];
        System.arraycopy(saltForPBKDF2Part1, 0, saltForPBKDF2, 0, saltForPBKDF2Part1.length);
        System.arraycopy(saltForPBKDF2Part2, 0, saltForPBKDF2, saltForPBKDF2Part1.length, saltForPBKDF2Part2.length);
        PBEKeySpec password = new PBEKeySpec(noQuotesPwd.toCharArray(), saltForPBKDF2, iterations, 512);
        SecretKeyFactory factory = O5Logon.getPBKDF2WithSHA512();
        return this.generateCheckedKey(password, factory);
    }

    private byte[] generateKb(byte[] ka, byte[] verifier, byte[] encryptedKBNibbles, byte[] encryptedKANibbles) throws Exception {
        byte[] kb = new byte[ka.length];
        O5Logon.generateRandomBytes(kb);
        byte[] encryptedKBBytes = this.encryptAES(verifier, kb, this.sessKeyStr);
        if (encryptedKBNibbles == null || encryptedKBNibbles.length != encryptedKANibbles.length) {
            throw new Exception("Resource D missing.");
        }
        this.bArray2Nibbles(encryptedKBBytes, encryptedKBNibbles);
        return kb;
    }

    private void generateSpeedKey(int confounderLen, int verifierType, byte[] pkEncryptedNibbles, int[] pkEncryptedNibblesLength, byte[] pk) throws Exception {
        byte[] confounder = new byte[confounderLen];
        if (verifierType == 18453) {
            O5Logon.generateRandomBytes(confounder);
            byte[] cfpk = new byte[confounderLen + pk.length];
            System.arraycopy(confounder, 0, cfpk, 0, confounderLen);
            System.arraycopy(pk, 0, cfpk, confounderLen, pk.length);
            byte[] pkEncrypted = this.encryptAESWithO5logonKey(cfpk, this.pkEncStr);
            pkEncryptedNibblesLength[0] = this.bArray2Nibbles(pkEncrypted, pkEncryptedNibbles);
        }
    }

    private void encryptPassword(byte[] noQuotesPwdNetBytes, byte[] encryptedPasswordNibbles, int confounderLen, int[] encryptedPasswordNibblesLength) throws Exception {
        if (encryptedPasswordNibbles == null) {
            throw new Exception("Resource E missing.");
        }
        byte[] confounder = new byte[confounderLen];
        O5Logon.generateRandomBytes(confounder);
        byte[] cfpwd = new byte[confounderLen + noQuotesPwdNetBytes.length];
        System.arraycopy(confounder, 0, cfpwd, 0, confounderLen);
        System.arraycopy(noQuotesPwdNetBytes, 0, cfpwd, confounderLen, noQuotesPwdNetBytes.length);
        byte[] jenc = this.encryptAESWithO5logonKey(cfpwd, this.pwdEncStr);
        encryptedPasswordNibblesLength[0] = this.bArray2Nibbles(jenc, encryptedPasswordNibbles);
    }

    private final byte[] generateCheckedKey(KeySpec keySpec, SecretKeyFactory keyFactory) throws Exception {
        byte[] ret;
        if (keySpec == null || keyFactory == null) {
            throw new Exception("Resource Z missing.");
        }
        SecretKey key = null;
        try {
            this.begin(Metrics.ConnectionEvent.AUTH_GEN_PK, this.genPKCounter);
            key = keyFactory.generateSecret(keySpec);
            this.end(Metrics.ConnectionEvent.AUTH_GEN_PK, this.genPKCounter);
            ++this.genPKCounter;
            ret = (byte[])key.getEncoded().clone();
        }
        catch (Exception e) {
            throw new Exception("Resource Y missing.");
        }
        finally {
            if (key != null) {
                key = null;
            }
        }
        return ret;
    }

    private final byte nibbleToHex(byte nibble) {
        return (byte)((nibble = (byte)(nibble & 0xF)) < 10 ? nibble + 48 : nibble - 10 + 65);
    }

    private final int bArray2Nibbles(byte[] array, byte[] nibbles) {
        int i;
        for (i = 0; i < array.length; ++i) {
            nibbles[i * 2] = this.nibbleToHex((byte)((array[i] & 0xF0) >> 4));
            nibbles[i * 2 + 1] = this.nibbleToHex((byte)(array[i] & 0xF));
        }
        return i * 2;
    }

    private final byte[] toBinArray(String hexStr) {
        byte[] bArray = new byte[hexStr.length() / 2];
        for (int i = 0; i < hexStr.length() / 2; ++i) {
            byte firstNibble = Byte.parseByte(hexStr.substring(2 * i, 2 * i + 1), 16);
            byte secondNibble = Byte.parseByte(hexStr.substring(2 * i + 1, 2 * i + 2), 16);
            int finalByte = secondNibble | firstNibble << 4;
            bArray[i] = (byte)finalByte;
        }
        return bArray;
    }

    private static final SecretKeyFactory getPBKDF2WithSHA512() throws NoSuchAlgorithmException {
        try {
            return SecretKeyFactory.getInstance("PBKDF2WithHmacSHA512");
        }
        catch (NoSuchAlgorithmException e) {
            NoSuchAlgorithmException standardNameException = e;
            try {
                return SecretKeyFactory.getInstance("PBKDF2WithSHA512");
            }
            catch (NoSuchAlgorithmException e2) {
                throw standardNameException;
            }
        }
    }

    public byte[] encryptJDWPValue(byte[] value) {
        try {
            byte[] encryptedPwd = this.encryptAES(this.o5logonKey, value, "AES/CBC/Zeros");
            byte[] nibbles = new byte[(encryptedPwd.length + 1) * 2];
            this.bArray2Nibbles(encryptedPwd, nibbles);
            nibbles[encryptedPwd.length * 2] = this.nibbleToHex((byte)0);
            nibbles[encryptedPwd.length * 2 + 1] = this.nibbleToHex((byte)1);
            return nibbles;
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public Diagnosable getDiagnosable() {
        return this.diagnosable;
    }
}

