/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.opensearch.plugin.websocket.message;

import de.virtimo.bpc.opensearch.plugin.dto.BackupJobDeleteActionDTO;
import de.virtimo.bpc.opensearch.plugin.utils.JsonUtil;
import de.virtimo.bpc.opensearch.plugin.utils.MapUtil;
import de.virtimo.bpc.opensearch.plugin.utils.StringUtil;
import de.virtimo.bpc.opensearch.plugin.utils.TimestampUtil;
import de.virtimo.bpc.opensearch.plugin.websocket.WebsocketMessage;
import de.virtimo.bpc.opensearch.plugin.websocket.WebsocketMessageException;
import java.io.IOException;
import java.time.Instant;
import java.time.LocalDateTime;
import java.util.Map;
import java.util.Set;
import org.opensearch.core.xcontent.ToXContent;

public class BackupJobDeleteWebsocketMessage
implements WebsocketMessage {
    private static final String PREFIX = "BackupJobDeleteMessage:::";
    private final BackupJobDeleteActionDTO deleteAction;
    private final Instant sendedAtInUtc;

    public BackupJobDeleteWebsocketMessage(BackupJobDeleteActionDTO deleteAction) {
        this(deleteAction, TimestampUtil.nowInUtc());
    }

    public BackupJobDeleteWebsocketMessage(BackupJobDeleteActionDTO deleteAction, Instant sendedAtInUtc) {
        this.deleteAction = deleteAction;
        this.sendedAtInUtc = sendedAtInUtc;
    }

    public BackupJobDeleteWebsocketMessage(Map<String, Object> msgMap) {
        this(new BackupJobDeleteActionDTO(MapUtil.getValueAsMap(msgMap, (String)"action", null)), MapUtil.getValueAsInstant(msgMap, (String)"sendedAt", (Instant)TimestampUtil.nowInUtc()));
        this.checkForWellKnownKeys(msgMap);
    }

    private void checkForWellKnownKeys(Map<String, Object> msgMap) {
        MapUtil.checkForWellKnownKeys(msgMap, Set.of("action", "sendedAt"));
    }

    private Map<String, Object> asMap() throws IOException {
        return MapUtil.mapOf((Object[])new Object[]{"action", JsonUtil.asMap((ToXContent)this.deleteAction), "sendedAt", this.sendedAtInUtc});
    }

    private String asJsonString() throws IOException {
        return JsonUtil.asJsonString(this.asMap());
    }

    public static boolean canBeCreatedFromMessage(String websocketMessage) {
        return !StringUtil.isNullOrEmpty((String)websocketMessage) && websocketMessage.startsWith(PREFIX);
    }

    public static BackupJobDeleteWebsocketMessage createFromMessage(String websocketMessage) throws WebsocketMessageException {
        try {
            String jsonMsgContent = websocketMessage.substring(PREFIX.length());
            Map jsonMap = JsonUtil.asMap((String)jsonMsgContent);
            return new BackupJobDeleteWebsocketMessage(jsonMap);
        }
        catch (Exception ex) {
            throw new WebsocketMessageException("Failed to create the '" + BackupJobDeleteWebsocketMessage.class.getName() + "' instance for the given websocket message: " + websocketMessage, ex);
        }
    }

    @Override
    public String getMessageToSend() throws WebsocketMessageException {
        try {
            return PREFIX + this.asJsonString();
        }
        catch (Exception ex) {
            throw new WebsocketMessageException("Failed to create the websocket message to be send.", ex);
        }
    }

    public BackupJobDeleteActionDTO getDeleteAction() {
        return this.deleteAction;
    }

    public Instant getSendedAtInUtc() {
        return this.sendedAtInUtc;
    }

    public LocalDateTime getSendedAtInLocalDateTime() {
        return TimestampUtil.asLocalDateTime((Instant)this.sendedAtInUtc);
    }

    public String toString() {
        return "BackupJobDeleteWebsocketMessage{deleteAction=" + String.valueOf(this.deleteAction) + ", sendedAtInUtc=" + String.valueOf(this.sendedAtInUtc) + "}";
    }
}

