/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.opensearch.plugin.websocket.message;

import de.virtimo.bpc.opensearch.plugin.dto.ReplicationJobsWithRuntimeStatsFromServerDTO;
import de.virtimo.bpc.opensearch.plugin.utils.JsonUtil;
import de.virtimo.bpc.opensearch.plugin.utils.MapUtil;
import de.virtimo.bpc.opensearch.plugin.utils.StringUtil;
import de.virtimo.bpc.opensearch.plugin.utils.TimestampUtil;
import de.virtimo.bpc.opensearch.plugin.websocket.WebsocketMessage;
import de.virtimo.bpc.opensearch.plugin.websocket.WebsocketMessageException;
import java.io.IOException;
import java.time.Instant;
import java.time.LocalDateTime;
import java.util.Map;
import java.util.Set;
import org.opensearch.core.xcontent.ToXContent;

public class ReplicationJobStatsResponseWebsocketMessage
implements WebsocketMessage {
    private static final String PREFIX = "ReplicationJobStatsResponse:::";
    private final String communicationId;
    private final ReplicationJobsWithRuntimeStatsFromServerDTO replicationJobStats;
    private final Instant sendedAtInUtc;

    public ReplicationJobStatsResponseWebsocketMessage(String communicationId, ReplicationJobsWithRuntimeStatsFromServerDTO replicationJobStats) {
        this(communicationId, replicationJobStats, TimestampUtil.nowInUtc());
    }

    public ReplicationJobStatsResponseWebsocketMessage(String communicationId, ReplicationJobsWithRuntimeStatsFromServerDTO replicationJobStats, Instant sendedAtInUtc) {
        this.communicationId = communicationId;
        this.replicationJobStats = replicationJobStats;
        this.sendedAtInUtc = sendedAtInUtc;
    }

    public ReplicationJobStatsResponseWebsocketMessage(Map<String, Object> msgMap) {
        this(MapUtil.getValueAsString(msgMap, (String)"communicationId", null), new ReplicationJobsWithRuntimeStatsFromServerDTO(MapUtil.getValueAsMap(msgMap, (String)"replicationJobStats", null)), MapUtil.getValueAsInstant(msgMap, (String)"sendedAt", (Instant)TimestampUtil.nowInUtc()));
        this.checkForWellKnownKeys(msgMap);
    }

    private void checkForWellKnownKeys(Map<String, Object> msgMap) {
        MapUtil.checkForWellKnownKeys(msgMap, Set.of("communicationId", "replicationJobStats", "sendedAt"));
    }

    private Map<String, Object> asMap() throws IOException {
        return MapUtil.mapOf((Object[])new Object[]{"communicationId", this.communicationId, "replicationJobStats", JsonUtil.asMap((ToXContent)this.replicationJobStats), "sendedAt", TimestampUtil.formatAsIsoInstantString((Instant)this.sendedAtInUtc)});
    }

    private String asJsonString() throws IOException {
        return JsonUtil.asJsonString(this.asMap());
    }

    public static boolean canBeCreatedFromMessage(String websocketMessage) {
        return !StringUtil.isNullOrEmpty((String)websocketMessage) && websocketMessage.startsWith(PREFIX);
    }

    public static ReplicationJobStatsResponseWebsocketMessage createFromMessage(String websocketMessage) throws WebsocketMessageException {
        try {
            String jsonMsgContent = websocketMessage.substring(PREFIX.length());
            Map jsonMap = JsonUtil.asMap((String)jsonMsgContent);
            return new ReplicationJobStatsResponseWebsocketMessage(jsonMap);
        }
        catch (Exception ex) {
            throw new WebsocketMessageException("Failed to create the '" + ReplicationJobStatsResponseWebsocketMessage.class.getName() + "' instance for the given websocket message: " + websocketMessage, ex);
        }
    }

    @Override
    public String getMessageToSend() throws WebsocketMessageException {
        try {
            return PREFIX + this.asJsonString();
        }
        catch (Exception ex) {
            throw new WebsocketMessageException("Failed to create the websocket message to be send.", ex);
        }
    }

    public String getCommunicationId() {
        return this.communicationId;
    }

    public ReplicationJobsWithRuntimeStatsFromServerDTO getReplicationJobStats() {
        return this.replicationJobStats;
    }

    public Instant getSendedAtInUtc() {
        return this.sendedAtInUtc;
    }

    public LocalDateTime getSendedAtInLocalDateTime() {
        return TimestampUtil.asLocalDateTime((Instant)this.sendedAtInUtc);
    }

    public String toString() {
        return "ReplicationJobStatsResponseWebsocketMessage{communicationId='" + this.communicationId + "', sendedAtInUtc=" + String.valueOf(this.sendedAtInUtc) + ", replicationJobStats=" + String.valueOf(this.replicationJobStats) + "}";
    }
}

