/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.jdbc.command;

import java.util.List;
import java.util.Map;
import org.apache.karaf.jdbc.command.JdbcCommandSupport;
import org.apache.karaf.jdbc.command.completers.DataSourcesNameCompleter;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Completion;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.apache.karaf.shell.support.table.Row;
import org.apache.karaf.shell.support.table.ShellTable;

@Command(scope="jdbc", name="tables", description="List the tables on a given JDBC datasource")
@Service
public class TablesCommand
extends JdbcCommandSupport {
    @Argument(index=0, name="datasource", description="The JDBC datasource name, its JNDI name or service.id to use", required=true, multiValued=false)
    @Completion(value=DataSourcesNameCompleter.class)
    String datasource;

    public Object execute() throws Exception {
        ShellTable table = new ShellTable();
        Map<String, List<String>> map = this.getJdbcService().tables(this.datasource);
        int rowCount = 0;
        for (String column : map.keySet()) {
            table.column(column);
            rowCount = map.get(column).size();
        }
        for (int i = 0; i < rowCount; ++i) {
            Row row = table.addRow();
            for (String column : map.keySet()) {
                row.addContent(new Object[]{map.get(column).get(i)});
            }
        }
        table.print(System.out);
        return null;
    }
}

