/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.opensearch.plugin;

import de.virtimo.bpc.opensearch.plugin.dto.OpenSearchPluginDTO;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.Logger;
import org.opensearch.common.logging.Loggers;

public class BpcWebsocketRequestsCoordinator<T extends OpenSearchPluginDTO> {
    private static final Logger LOGGER = Loggers.getLogger(BpcWebsocketRequestsCoordinator.class, (String[])new String[]{"os-bpc-plugin"});
    private final Map<String, BpcWebsocketRequest> requests = new HashMap<String, BpcWebsocketRequest>();

    public void prepareFor(String communicationId, int numberOfExpectedMessages) {
        LOGGER.debug("{}.prepareFor communicationId={}, numberOfExpectedMessages={}", (Object)this.getClass().getSimpleName(), (Object)communicationId, (Object)numberOfExpectedMessages);
        this.requests.put(communicationId, new BpcWebsocketRequest(this, numberOfExpectedMessages));
    }

    public void updateForSentWebsocketMessages(String communicationId, int successful, int failed) {
        LOGGER.debug("{}.updateForSentWebsocketMessages communicationId={}, successful={}, failed={}", (Object)this.getClass().getSimpleName(), (Object)communicationId, (Object)successful, (Object)failed);
        this.requests.get(communicationId).updateForSentWebsocketMessages(successful, failed);
    }

    public void handleReceivedDTO(String communicationId, T receivedDTO) {
        LOGGER.debug("{}.handleReceivedDTO communicationId={}, receivedDTO=...", (Object)this.getClass().getSimpleName(), (Object)communicationId);
        this.requests.get(communicationId).handleReceivedDTO(receivedDTO);
    }

    public void await(String communicationId) throws InterruptedException {
        LOGGER.debug("{}.await communicationId={}", (Object)this.getClass().getSimpleName(), (Object)communicationId);
        this.requests.get(communicationId).await();
    }

    public List<T> getAndRemove(String communicationId) {
        LOGGER.debug("{}.getAndRemove communicationId={}", (Object)this.getClass().getSimpleName(), (Object)communicationId);
        BpcWebsocketRequest request = this.requests.remove(communicationId);
        return request.getReceivedDTOsFromServers();
    }

    public void remove(String communicationId) {
        LOGGER.debug("{}.remove communicationId={}", (Object)this.getClass().getSimpleName(), (Object)communicationId);
        this.requests.remove(communicationId);
    }

    private class BpcWebsocketRequest {
        private final CountDownLatch messagesCountDownLatch;
        private final List<T> receivedDTOs;

        public BpcWebsocketRequest(BpcWebsocketRequestsCoordinator bpcWebsocketRequestsCoordinator, int numberOfExpectedMessages) {
            LOGGER.debug("{} numberOfExpectedMessages={}", (Object)this.getClass().getSimpleName(), (Object)numberOfExpectedMessages);
            this.messagesCountDownLatch = new CountDownLatch(numberOfExpectedMessages);
            this.receivedDTOs = new ArrayList();
        }

        public void updateForSentWebsocketMessages(int successful, int failed) {
            LOGGER.debug("{}.updateForSentWebsocketMessages successful={}, failed={}", (Object)this.getClass().getSimpleName(), (Object)successful, (Object)failed);
            for (int i = 0; i < failed; ++i) {
                this.messagesCountDownLatch.countDown();
            }
        }

        public void handleReceivedDTO(T receivedDTO) {
            LOGGER.debug("{}.handleReceivedDTO receivedDTO=...", (Object)this.getClass().getSimpleName());
            this.receivedDTOs.add(receivedDTO);
            this.messagesCountDownLatch.countDown();
        }

        public void await() throws InterruptedException {
            LOGGER.debug("{}.await", (Object)this.getClass().getSimpleName());
            this.messagesCountDownLatch.await(30L, TimeUnit.SECONDS);
        }

        public List<T> getReceivedDTOsFromServers() {
            LOGGER.debug("{}.getReceivedDTOsFromServers", (Object)this.getClass().getSimpleName());
            return this.receivedDTOs;
        }
    }
}

