/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.opensearch.plugin;

import de.virtimo.bpc.opensearch.plugin.Manager;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.logging.log4j.Logger;
import org.opensearch.cluster.ClusterChangedEvent;
import org.opensearch.cluster.ClusterStateListener;
import org.opensearch.cluster.node.DiscoveryNode;
import org.opensearch.cluster.node.DiscoveryNodes;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.logging.Loggers;

public class ClusterObserver {
    private static final Logger LOGGER = Loggers.getLogger(ClusterObserver.class, (String[])new String[]{"os-bpc-plugin"});
    private final ClusterService clusterService;
    private final ClusterStateListener clusterStateListener;
    private final Manager manager;

    public ClusterObserver(ClusterService clusterService, Manager manager) {
        LOGGER.debug("ClusterSettingsObserver clusterService={}, manager={}", (Object)clusterService, (Object)manager);
        this.clusterService = clusterService;
        this.manager = manager;
        this.clusterStateListener = new ClusterStateListener(){

            public void clusterChanged(ClusterChangedEvent clusterChangedEvent) {
                DiscoveryNodes.Delta nodesDelta;
                if (clusterChangedEvent.nodesRemoved()) {
                    nodesDelta = clusterChangedEvent.nodesDelta();
                    ClusterObserver.this.onNodesRemovedFromCluster(nodesDelta.removedNodes());
                }
                if (clusterChangedEvent.nodesAdded()) {
                    nodesDelta = clusterChangedEvent.nodesDelta();
                    ClusterObserver.this.onNodesAddedToCluster(nodesDelta.addedNodes());
                }
            }
        };
    }

    public void doStart() {
        LOGGER.debug("doStart");
        this.clusterService.addListener(this.clusterStateListener);
    }

    public void doStop() {
        LOGGER.debug("doStop");
        this.clusterService.removeListener(this.clusterStateListener);
    }

    private Set<String> getNodeNames(List<DiscoveryNode> nodes) {
        HashSet<String> result = new HashSet<String>();
        if (nodes != null) {
            for (DiscoveryNode node : nodes) {
                result.add(node.getName());
            }
        }
        return result;
    }

    private void onNodesRemovedFromCluster(List<DiscoveryNode> removedNodes) {
        LOGGER.debug("onNodesRemovedFromCluster removedNodes={}", removedNodes);
        final Set<String> namesOfRemovedNodes = this.getNodeNames(removedNodes);
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                ClusterObserver.this.manager.unregisterRemovedOpenSearchNodes(namesOfRemovedNodes);
            }
        });
        t.start();
    }

    private void onNodesAddedToCluster(final List<DiscoveryNode> addedNodes) {
        LOGGER.debug("onNodesAddedToCluster addedNodes={}", addedNodes);
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                ClusterObserver.this.manager.handleJustAddedOpenSearchNodes(addedNodes);
            }
        });
        t.start();
    }
}

