/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.tx.control.service.xa.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.apache.aries.tx.control.service.common.impl.AbstractTransactionContextImpl;
import org.apache.aries.tx.control.service.xa.impl.LocalResourceSupport;
import org.apache.aries.tx.control.service.xa.impl.NamedXAResourceImpl;
import org.apache.geronimo.transaction.manager.RecoveryWorkAroundTransactionManager;
import org.apache.geronimo.transaction.manager.SetRollbackOnlyException;
import org.osgi.service.transaction.control.LocalResource;
import org.osgi.service.transaction.control.TransactionContext;
import org.osgi.service.transaction.control.TransactionException;
import org.osgi.service.transaction.control.TransactionRolledBackException;
import org.osgi.service.transaction.control.TransactionStatus;

public class TransactionContextImpl
extends AbstractTransactionContextImpl
implements TransactionContext {
    final List<LocalResource> resources = new ArrayList<LocalResource>();
    private final Transaction oldTran;
    private final Transaction currentTransaction;
    private final AtomicReference<TransactionStatus> completionState = new AtomicReference();
    private final RecoveryWorkAroundTransactionManager transactionManager;
    private final Object key;
    private final boolean readOnly;
    private LocalResourceSupport localResourceSupport;
    private boolean noMorePreCompletion;

    public TransactionContextImpl(RecoveryWorkAroundTransactionManager transactionManager, boolean readOnly, LocalResourceSupport localResourceSupport) {
        this.transactionManager = transactionManager;
        this.readOnly = readOnly;
        this.localResourceSupport = localResourceSupport;
        Transaction tmp = null;
        try {
            tmp = transactionManager.suspend();
            transactionManager.begin();
        }
        catch (Exception e) {
            if (tmp != null) {
                try {
                    transactionManager.resume(tmp);
                }
                catch (Exception e1) {
                    e.addSuppressed(e1);
                }
            }
            throw new TransactionException("There was a serious error creating a transaction");
        }
        this.oldTran = tmp;
        this.currentTransaction = transactionManager.getTransaction();
        this.key = transactionManager.getTransactionKey();
    }

    @Override
    public Object getTransactionKey() {
        return this.key;
    }

    @Override
    public boolean getRollbackOnly() throws IllegalStateException {
        switch (this.getTransactionStatus()) {
            case MARKED_ROLLBACK: 
            case ROLLING_BACK: 
            case ROLLED_BACK: {
                return true;
            }
        }
        return false;
    }

    @Override
    public void setRollbackOnly() throws IllegalStateException {
        TransactionStatus status = this.getTransactionStatus();
        switch (status) {
            case MARKED_ROLLBACK: 
            case ACTIVE: {
                try {
                    this.currentTransaction.setRollbackOnly();
                    break;
                }
                catch (Exception e) {
                    throw new TransactionException("Unable to set rollback for the transaction", e);
                }
            }
            case COMMITTING: {
                throw new IllegalStateException("The transaction is already being committed");
            }
            case COMMITTED: {
                throw new IllegalStateException("The transaction is already committed");
            }
            case ROLLING_BACK: 
            case ROLLED_BACK: {
                break;
            }
            default: {
                throw new IllegalStateException("The transaction is in an unkown state");
            }
        }
    }

    @Override
    protected void safeSetRollbackOnly() {
        TransactionStatus status = this.getTransactionStatus();
        switch (status) {
            case MARKED_ROLLBACK: 
            case ACTIVE: {
                try {
                    this.currentTransaction.setRollbackOnly();
                    break;
                }
                catch (Exception e) {
                    throw new TransactionException("Unable to set rollback for the transaction", e);
                }
            }
        }
    }

    @Override
    public TransactionStatus getTransactionStatus() {
        return Optional.ofNullable(this.completionState.get()).orElseGet(this::getStatusFromTransaction);
    }

    private TransactionStatus getStatusFromTransaction() {
        int status;
        try {
            status = this.currentTransaction.getStatus();
        }
        catch (SystemException e) {
            throw new TransactionException("Unable to determine the state of the transaction.", e);
        }
        switch (status) {
            case 0: {
                return TransactionStatus.ACTIVE;
            }
            case 1: {
                return TransactionStatus.MARKED_ROLLBACK;
            }
            case 7: {
                return TransactionStatus.PREPARING;
            }
            case 2: {
                return TransactionStatus.PREPARED;
            }
            case 8: {
                return TransactionStatus.COMMITTING;
            }
            case 3: {
                return TransactionStatus.COMMITTED;
            }
            case 9: {
                return TransactionStatus.ROLLING_BACK;
            }
            case 4: {
                return TransactionStatus.ROLLED_BACK;
            }
        }
        throw new TransactionException("Unable to determine the state of the transaction: " + status);
    }

    @Override
    public void preCompletion(Runnable job) throws IllegalStateException {
        if (this.noMorePreCompletion) {
            throw new IllegalStateException("The current transactional work has finished executing so a pre-completion callback can no longer be registered");
        }
        this.preCompletion.add(job);
    }

    @Override
    public void postCompletion(Consumer<TransactionStatus> job) throws IllegalStateException {
        TransactionStatus status = this.getTransactionStatus();
        if (status == TransactionStatus.COMMITTED || status == TransactionStatus.ROLLED_BACK) {
            throw new IllegalStateException("The current transaction is in state " + (Object)((Object)status));
        }
        this.postCompletion.add(job);
    }

    @Override
    public void registerXAResource(XAResource resource, String name) {
        TransactionStatus status = this.getTransactionStatus();
        if (status.compareTo(TransactionStatus.MARKED_ROLLBACK) > 0) {
            throw new IllegalStateException("The current transaction is in state " + (Object)((Object)status));
        }
        try {
            if (name == null) {
                this.currentTransaction.enlistResource(resource);
            } else {
                NamedXAResourceImpl res = new NamedXAResourceImpl(name, resource, this.transactionManager, true);
                this.postCompletion(x -> res.close());
                this.currentTransaction.enlistResource(res);
            }
        }
        catch (Exception e) {
            throw new TransactionException("The transaction was unable to enlist a resource", e);
        }
    }

    @Override
    public void registerLocalResource(LocalResource resource) {
        TransactionStatus status = this.getTransactionStatus();
        if (status.compareTo(TransactionStatus.MARKED_ROLLBACK) > 0) {
            throw new IllegalStateException("The current transaction is in state " + (Object)((Object)status));
        }
        switch (this.localResourceSupport) {
            case ENFORCE_SINGLE: {
                if (!this.resources.isEmpty()) {
                    throw new TransactionException("Only one local resource may be added. Adding multiple local resources increases the risk of inconsistency on failure.");
                }
            }
            case ENABLED: {
                this.resources.add(resource);
                break;
            }
            case DISABLED: {
                throw new TransactionException("This Transaction Control Service does not support local resources");
            }
            default: {
                throw new IllegalArgumentException("Unknown local resources configuration option");
            }
        }
    }

    @Override
    public boolean supportsXA() {
        return true;
    }

    @Override
    public boolean supportsLocal() {
        return this.localResourceSupport != LocalResourceSupport.DISABLED;
    }

    @Override
    public boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    protected boolean isAlive() {
        TransactionStatus status = this.getTransactionStatus();
        return status != TransactionStatus.COMMITTED && status != TransactionStatus.ROLLED_BACK;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void finish() {
        block18: {
            if (!this.resources.isEmpty()) {
                LocalXAResourceImpl localResource = new LocalXAResourceImpl();
                try {
                    this.currentTransaction.enlistResource(localResource);
                }
                catch (Exception e) {
                    this.safeSetRollbackOnly();
                    this.recordFailure(e);
                    try {
                        localResource.rollback(null);
                    }
                    catch (XAException e1) {
                        this.recordFailure(e1);
                    }
                }
            }
            try {
                TxListener listener = new TxListener();
                try {
                    this.transactionManager.registerInterposedSynchronization(listener);
                    if (this.getRollbackOnly()) {
                        listener.beforeCompletion();
                        this.transactionManager.rollback();
                        break block18;
                    }
                    try {
                        this.transactionManager.commit();
                    }
                    catch (RollbackException re) {
                        if (re.getCause() instanceof SetRollbackOnlyException) {
                            break block18;
                        }
                        TransactionRolledBackException tre = new TransactionRolledBackException(re.getMessage(), re);
                        throw tre;
                    }
                }
                catch (Exception e) {
                    TransactionException te = e instanceof TransactionException ? (TransactionException)e : new TransactionException("An error occurred in the transaction", e);
                    this.recordFailure(te);
                }
            }
            finally {
                try {
                    this.transactionManager.resume(this.oldTran);
                }
                catch (Exception e) {
                    this.recordFailure(e);
                }
            }
        }
    }

    private class TxListener
    implements Synchronization {
        private TxListener() {
        }

        @Override
        public void beforeCompletion() {
            TransactionContextImpl.this.noMorePreCompletion = true;
            TransactionContextImpl.this.beforeCompletion(() -> TransactionContextImpl.this.safeSetRollbackOnly());
        }

        @Override
        public void afterCompletion(int status) {
            TransactionStatus ts = status == 3 ? TransactionStatus.COMMITTED : TransactionStatus.ROLLED_BACK;
            TransactionContextImpl.this.completionState.set(ts);
            TransactionContextImpl.this.afterCompletion(ts);
        }
    }

    private class LocalXAResourceImpl
    implements XAResource {
        private final AtomicBoolean finished = new AtomicBoolean();

        private LocalXAResourceImpl() {
        }

        @Override
        public void commit(Xid xid, boolean onePhase) throws XAException {
            if (!this.finished.compareAndSet(false, true)) {
                return;
            }
            this.doCommit();
        }

        private void doCommit() throws XAException {
            AtomicBoolean commit = new AtomicBoolean(true);
            ArrayList committed = new ArrayList(TransactionContextImpl.this.resources.size());
            ArrayList rolledback = new ArrayList(0);
            TransactionContextImpl.this.resources.stream().forEach(lr -> {
                try {
                    if (commit.get()) {
                        lr.commit();
                        committed.add(lr);
                    } else {
                        lr.rollback();
                        rolledback.add(lr);
                    }
                }
                catch (Exception e) {
                    TransactionContextImpl.this.recordFailure(e);
                    if (committed.isEmpty()) {
                        commit.set(false);
                        TransactionContextImpl.this.completionState.set(TransactionStatus.ROLLING_BACK);
                    }
                    rolledback.add(lr);
                }
            });
            if (!rolledback.isEmpty()) {
                if (committed.isEmpty()) {
                    throw (XAException)new XAException(104).initCause((Throwable)TransactionContextImpl.this.firstUnexpectedException.get());
                }
                throw (XAException)new XAException(5).initCause((Throwable)TransactionContextImpl.this.firstUnexpectedException.get());
            }
        }

        @Override
        public void end(Xid xid, int flags) throws XAException {
        }

        @Override
        public void forget(Xid xid) throws XAException {
        }

        @Override
        public int getTransactionTimeout() throws XAException {
            return 3600;
        }

        @Override
        public boolean isSameRM(XAResource xares) throws XAException {
            return this == xares;
        }

        @Override
        public int prepare(Xid xid) throws XAException {
            if (!this.finished.compareAndSet(false, true)) {
                switch (TransactionContextImpl.this.getTransactionStatus()) {
                    case COMMITTING: {
                        return 0;
                    }
                    case ROLLING_BACK: {
                        throw new XAException(104);
                    }
                }
                throw new XAException(105);
            }
            TransactionContextImpl.this.completionState.set(TransactionStatus.COMMITTING);
            this.doCommit();
            return 0;
        }

        @Override
        public Xid[] recover(int flag) throws XAException {
            return new Xid[0];
        }

        @Override
        public void rollback(Xid xid) throws XAException {
            if (!this.finished.compareAndSet(false, true)) {
                return;
            }
            TransactionContextImpl.this.resources.stream().forEach(lr -> {
                try {
                    lr.rollback();
                }
                catch (Exception e) {
                    TransactionContextImpl.this.recordFailure(e);
                }
            });
        }

        @Override
        public boolean setTransactionTimeout(int seconds) throws XAException {
            return false;
        }

        @Override
        public void start(Xid xid, int flags) throws XAException {
        }
    }
}

