/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.obr.command;

import org.apache.felix.bundlerepository.Repository;
import org.apache.felix.bundlerepository.RepositoryAdmin;
import org.apache.karaf.obr.command.ObrCommandSupport;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.apache.karaf.shell.support.table.ShellTable;

@Command(scope="obr", name="url-list", description="Displays the repository URLs currently associated with the OBR service.")
@Service
public class ListUrlCommand
extends ObrCommandSupport {
    @Option(name="--no-format", description="Disable table rendered output", required=false, multiValued=false)
    boolean noFormat;

    @Override
    protected void doExecute(RepositoryAdmin admin) {
        ShellTable table = new ShellTable();
        table.column("Index");
        table.column("OBR URL");
        table.emptyTableText("No OBR repository URL");
        Repository[] repos = admin.listRepositories();
        if (repos != null) {
            for (int i = 0; i < repos.length; ++i) {
                table.addRow().addContent(new Object[]{i, repos[i].getURI()});
            }
        }
        table.print(System.out, !this.noFormat);
    }
}

