/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.jndi.command;

import java.util.Map;
import org.apache.karaf.jndi.JndiService;
import org.apache.karaf.jndi.command.completers.ContextsCompleter;
import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Completion;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.apache.karaf.shell.support.table.ShellTable;

@Command(scope="jndi", name="names", description="List the JNDI names.")
@Service
public class NamesCommand
implements Action {
    @Argument(index=0, name="context", description="The JNDI context to display the names", required=false, multiValued=false)
    @Completion(value=ContextsCompleter.class)
    String context;
    @Reference
    JndiService jndiService;

    public Object execute() throws Exception {
        ShellTable table = new ShellTable();
        table.column("JNDI Name");
        table.column("Class Name");
        Map<String, String> names = this.context == null ? this.jndiService.names() : this.jndiService.names(this.context);
        for (String name : names.keySet()) {
            table.addRow().addContent(new Object[]{name, names.get(name)});
        }
        table.print(System.out);
        return null;
    }
}

