/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.opensearch.plugin;

import de.virtimo.bpc.opensearch.plugin.ChangesFilter;
import de.virtimo.bpc.opensearch.plugin.dto.OpenSearchPluginDTO;
import de.virtimo.bpc.opensearch.plugin.utils.MapUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.logging.log4j.Logger;
import org.opensearch.common.logging.Loggers;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;

public class ChangesFilters
implements OpenSearchPluginDTO {
    private static final Logger LOGGER = Loggers.getLogger(ChangesFilters.class, (String[])new String[]{"os-bpc-plugin"});
    private final Map<String, ChangesFilter> filters = new HashMap<String, ChangesFilter>();
    private static final Object FILTERS_LOCK = new Object();

    public ChangesFilters() {
    }

    public ChangesFilters(Map<String, Object> changesFiltersMap) {
        this();
        this.checkForWellKnownKeys(changesFiltersMap);
        Set changesFilters = MapUtil.getArrayValueAsSetOfObjects(changesFiltersMap, (String)"entries", ChangesFilter.class);
        for (ChangesFilter filter : changesFilters) {
            this.filters.put(filter.getKey(), filter);
        }
    }

    private void checkForWellKnownKeys(Map<String, Object> map) {
        MapUtil.checkForWellKnownKeys(map, Set.of("entries"));
    }

    public ChangesFilters(StreamInput in) throws IOException {
        this();
        this.filters.putAll(in.readMap(StreamInput::readString, ChangesFilter::new));
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeMap(this.filters, StreamOutput::writeString, (o, v) -> v.writeTo(o));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        Object object = FILTERS_LOCK;
        synchronized (object) {
            builder.startObject();
            builder.startArray("entries");
            for (ChangesFilter changesFilter : new ArrayList<ChangesFilter>(this.filters.values())) {
                changesFilter.toXContent(builder, params);
            }
            builder.endArray();
            builder.endObject();
            return builder;
        }
    }

    public static ChangesFilters fromXContent(XContentParser parser) throws IOException {
        return new ChangesFilters(parser.map());
    }

    public List<ChangesFilter> getAll() {
        LOGGER.debug("getAll");
        return new ArrayList<ChangesFilter>(this.filters.values());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ChangesFilter> getAll(String serverUUID) {
        LOGGER.debug("getAll serverUUID={}", (Object)serverUUID);
        Object object = FILTERS_LOCK;
        synchronized (object) {
            if (serverUUID == null) {
                return new ArrayList<ChangesFilter>(this.filters.values());
            }
            ArrayList<ChangesFilter> result = new ArrayList<ChangesFilter>();
            for (ChangesFilter filter : this.filters.values()) {
                if (!filter.belongsToServerUUID(serverUUID)) continue;
                result.add(filter);
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ChangesFilter getFilter(String index, Set<String> aliases) {
        LOGGER.debug("getFilter index={}, aliases={}", (Object)index, aliases);
        Object object = FILTERS_LOCK;
        synchronized (object) {
            ChangesFilter indexFilter = this.filters.get(ChangesFilter.getKey(index));
            if (indexFilter != null) {
                return indexFilter;
            }
            if (aliases != null) {
                for (String alias : aliases) {
                    ChangesFilter aliasFilter = this.filters.get(ChangesFilter.getKey(alias));
                    if (aliasFilter == null) continue;
                    return aliasFilter;
                }
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(String serverUUID, String index, boolean sendIndexEventsOnlyForModifiedSources) {
        LOGGER.debug("add serverUUID={}, index={}, sendIndexEventsOnlyForModifiedSources={}", (Object)serverUUID, (Object)index, (Object)sendIndexEventsOnlyForModifiedSources);
        if (serverUUID == null || index == null) {
            return false;
        }
        Object object = FILTERS_LOCK;
        synchronized (object) {
            String changesFilterKey = ChangesFilter.getKey(index);
            ChangesFilter existingFilter = this.filters.get(changesFilterKey);
            if (existingFilter == null) {
                ChangesFilter changesFilter = new ChangesFilter(index, sendIndexEventsOnlyForModifiedSources);
                changesFilter.addServerUUID(serverUUID);
                this.filters.put(changesFilterKey, changesFilter);
                return true;
            }
            return existingFilter.addServerUUID(serverUUID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeAll(String serverUUID) {
        LOGGER.debug("removeAll serverUUID={}", (Object)serverUUID);
        if (serverUUID == null) {
            return false;
        }
        Object object = FILTERS_LOCK;
        synchronized (object) {
            boolean removed = false;
            HashSet<String> existingsKeys = new HashSet<String>(this.filters.keySet());
            for (String existingsKey : existingsKeys) {
                if (!this._removeByFilterKey(serverUUID, existingsKey)) continue;
                removed = true;
            }
            return removed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(String serverUUID, String index) {
        LOGGER.debug("remove serverUUID={}, index={}", (Object)serverUUID, (Object)index);
        if (index == null) {
            return false;
        }
        Object object = FILTERS_LOCK;
        synchronized (object) {
            return this._removeByFilterKey(serverUUID, ChangesFilter.getKey(index));
        }
    }

    private boolean _removeByFilterKey(String serverUUID, String changesFilterKey) {
        ChangesFilter existingFilter;
        LOGGER.debug("_removeByFilterKey serverUUID={}, changesFilterKey={}", (Object)serverUUID, (Object)changesFilterKey);
        if (changesFilterKey != null && (existingFilter = this.filters.get(changesFilterKey)) != null) {
            existingFilter.removeServerUUID(serverUUID);
            if (!existingFilter.hasServerUUIDs()) {
                this.filters.remove(changesFilterKey);
            }
            return true;
        }
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ChangesFilters that = (ChangesFilters)o;
        return Objects.equals(this.filters, that.filters);
    }

    public int hashCode() {
        return Objects.hash(this.filters);
    }

    public String toString() {
        return "ChangesFilters{filters=" + String.valueOf(this.filters) + "}";
    }
}

