/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.opensearch.plugin.rest.action.config;

import de.virtimo.bpc.opensearch.plugin.BpcPlugin;
import de.virtimo.bpc.opensearch.plugin.Manager;
import de.virtimo.bpc.opensearch.plugin.dto.ConfigDTO;
import de.virtimo.bpc.opensearch.plugin.dto.OpenSearchPluginDTO;
import de.virtimo.bpc.opensearch.plugin.rest.action.BaseBpcPluginRestHandler;
import java.io.IOException;
import java.util.List;
import java.util.Properties;
import org.apache.logging.log4j.Logger;
import org.opensearch.common.logging.Loggers;
import org.opensearch.common.settings.Settings;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.RestChannel;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.transport.client.node.NodeClient;

public class RestGetConfigAction
extends BaseBpcPluginRestHandler {
    private static final Logger LOGGER = Loggers.getLogger(RestGetConfigAction.class, (String[])new String[]{"os-bpc-plugin"});
    private final Settings settings;

    public RestGetConfigAction(Settings settings) {
        this.settings = settings;
    }

    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.GET, "/_bpc/config"));
    }

    public String getName() {
        return "get_config_action";
    }

    @Override
    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient nodeClient, Manager manager) throws IOException {
        LOGGER.debug("prepareRequest request={}, nodeClient={}, manager={}", (Object)request, (Object)nodeClient, (Object)manager);
        return channel -> {
            Properties props = new Properties();
            props.load(((Object)((Object)this)).getClass().getResourceAsStream("/plugin-descriptor.properties"));
            ConfigDTO config = new ConfigDTO(BpcPlugin.getSettingsValueAsInt(this.settings, "os-bpc-plugin.websocket.port", BpcPlugin.DEFAULT_WEBSOCKET_PORT), (String)props.get("name"), (String)props.get("version"));
            this.sendDTO((RestChannel)channel, (OpenSearchPluginDTO)config);
        };
    }
}

