/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.opensearch.plugin.rest.action.replication;

import de.virtimo.bpc.opensearch.plugin.BpcConnection;
import de.virtimo.bpc.opensearch.plugin.BpcConnections;
import de.virtimo.bpc.opensearch.plugin.Manager;
import de.virtimo.bpc.opensearch.plugin.ReplicationJob;
import de.virtimo.bpc.opensearch.plugin.ReplicationJobs;
import de.virtimo.bpc.opensearch.plugin.ReplicationJobsOrchestrator;
import de.virtimo.bpc.opensearch.plugin.dto.OpenSearchPluginDTO;
import de.virtimo.bpc.opensearch.plugin.dto.ReplicationJobsDetailsDTO;
import de.virtimo.bpc.opensearch.plugin.dto.ServerStateInfoDTO;
import de.virtimo.bpc.opensearch.plugin.rest.action.BaseBpcPluginRestHandler;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.logging.log4j.Logger;
import org.opensearch.common.logging.Loggers;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.RestChannel;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.transport.client.node.NodeClient;

public class RestGetReplicationJobsDetailsAction
extends BaseBpcPluginRestHandler {
    private static final Logger LOGGER = Loggers.getLogger(RestGetReplicationJobsDetailsAction.class, (String[])new String[]{"os-bpc-plugin"});

    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.GET, "/_bpc/replicationjobs/details"));
    }

    public String getName() {
        return "get_replication_jobs_details_action";
    }

    @Override
    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient nodeClient, Manager manager) throws IOException {
        LOGGER.debug("prepareRequest request={}, nodeClient={}, manager={}", (Object)request, (Object)nodeClient, (Object)manager);
        return channel -> {
            BpcConnections bpcConnections = manager.getConnections();
            Set<String> serverUUIDs = bpcConnections.getUUIDsOfServersThatCanBeUsedForReplication();
            ReplicationJobs currentJobs = manager.getCurrentReplicationJobs();
            ReplicationJobsOrchestrator orchestrator = new ReplicationJobsOrchestrator(currentJobs);
            ReplicationJobsDetailsDTO replicationJobsDetails = new ReplicationJobsDetailsDTO(orchestrator.areJobsEquallyDistributed(serverUUIDs), RestGetReplicationJobsDetailsAction.createServers(bpcConnections, serverUUIDs, currentJobs), RestGetReplicationJobsDetailsAction.createJobs(currentJobs));
            this.sendDTO((RestChannel)channel, (OpenSearchPluginDTO)replicationJobsDetails);
        };
    }

    private static List<ReplicationJobsDetailsDTO.Server> createServers(BpcConnections bpcConnections, Set<String> serverUUIDs, ReplicationJobs currentJobs) {
        ArrayList<ReplicationJobsDetailsDTO.Server> servers = new ArrayList<ReplicationJobsDetailsDTO.Server>();
        for (BpcConnection bpcConnection : bpcConnections.getAll()) {
            ServerStateInfoDTO serverStateInfo = bpcConnection.getServerStateInfo();
            if (serverStateInfo == null) continue;
            String serverUUID = serverStateInfo.getServerUUID();
            servers.add(new ReplicationJobsDetailsDTO.Server(serverUUID, serverStateInfo.canBeUsedForReplication(), serverUUIDs.contains(serverUUID) ? currentJobs.getReplicationJobsByServerUUID(serverUUID).size() : 0));
        }
        return servers;
    }

    private static List<ReplicationJobsDetailsDTO.Job> createJobs(ReplicationJobs currentJobs) {
        ArrayList<ReplicationJobsDetailsDTO.Job> jobs = new ArrayList<ReplicationJobsDetailsDTO.Job>();
        for (ReplicationJob job : currentJobs) {
            jobs.add(new ReplicationJobsDetailsDTO.Job(job.getId(), job.isEnabled(), job.getSettingsHash(), job.getServerUUID(), job.getState().name()));
        }
        return jobs;
    }
}

