/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.opensearch.plugin.rest.action.replication;

import de.virtimo.bpc.opensearch.plugin.Manager;
import de.virtimo.bpc.opensearch.plugin.ReplicationJob;
import de.virtimo.bpc.opensearch.plugin.ReplicationJobs;
import de.virtimo.bpc.opensearch.plugin.dto.ReplicationJobDTO;
import de.virtimo.bpc.opensearch.plugin.dto.ReplicationJobsDTO;
import de.virtimo.bpc.opensearch.plugin.rest.action.BaseBpcPluginRestHandler;
import de.virtimo.bpc.opensearch.plugin.rest.action.RequestBodyMissingException;
import de.virtimo.bpc.opensearch.plugin.transport.action.replication.jobs.set.ReplicationJobsSetResponse;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.Logger;
import org.opensearch.common.logging.Loggers;
import org.opensearch.core.action.ActionListener;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.transport.client.node.NodeClient;

public class RestSetReplicationJobsAction
extends BaseBpcPluginRestHandler {
    private static final Logger LOGGER = Loggers.getLogger(RestSetReplicationJobsAction.class, (String[])new String[]{"os-bpc-plugin"});

    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.POST, "/_bpc/replicationjobs"));
    }

    public String getName() {
        return "set_replication_jobs_action";
    }

    @Override
    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient nodeClient, Manager manager) throws IOException, RequestBodyMissingException {
        LOGGER.debug("prepareRequest request={}, nodeClient={}, manager={}", (Object)request, (Object)nodeClient, (Object)manager);
        Map<String, Object> msgBodyMap = this.getMandatoryJsonBodyAsMap(request);
        ReplicationJobsDTO replicationJobsDTO = new ReplicationJobsDTO(msgBodyMap);
        return channel -> {
            ReplicationJobs replicationJobs = new ReplicationJobs();
            for (ReplicationJobDTO replicationJobDTO : replicationJobsDTO) {
                ReplicationJob replicationJob = new ReplicationJob(replicationJobDTO.getId(), replicationJobDTO.isEnabled(), replicationJobDTO.getSettingsHash());
                replicationJobs.add(replicationJob);
            }
            manager.processReceivedReplicationJobs(replicationJobs, new ActionListener<ReplicationJobsSetResponse>(){

                public void onResponse(ReplicationJobsSetResponse nodeBroadcasterResponse) {
                    RestSetReplicationJobsAction.this.sendOK(channel);
                }

                public void onFailure(Exception ex) {
                    RestSetReplicationJobsAction.this.sendError(channel, ex);
                }
            });
        };
    }
}

