/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.opensearch.plugin.transport.action;

import java.util.Objects;
import java.util.stream.Collectors;
import org.opensearch.OpenSearchException;
import org.opensearch.action.FailedNodeException;
import org.opensearch.action.support.nodes.BaseNodesResponse;

public class AggregatedNodesResponseException {
    public static OpenSearchException create(String message, BaseNodesResponse<?> baseNodesResponse) {
        Objects.requireNonNull(message, "'message' must bot be null");
        Objects.requireNonNull(baseNodesResponse, "'baseNodesResponse' must not be null");
        OpenSearchException e = null;
        if (baseNodesResponse.hasFailures()) {
            String nodeIds = baseNodesResponse.failures().stream().map(FailedNodeException::nodeId).collect(Collectors.joining(","));
            e = new OpenSearchException(message + " [" + nodeIds + "]", new Object[0]);
            for (FailedNodeException failure : baseNodesResponse.failures()) {
                e.addSuppressed((Throwable)failure);
            }
        }
        return e;
    }
}

