/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.opensearch.plugin.dto;

import de.virtimo.bpc.opensearch.plugin.dto.BackupJobInfoDTO;
import de.virtimo.bpc.opensearch.plugin.dto.OpenSearchPluginDTO;
import de.virtimo.bpc.opensearch.plugin.utils.MapUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;

public class BackupJobInfosDTO
implements OpenSearchPluginDTO,
Iterable<BackupJobInfoDTO> {
    private final List<BackupJobInfoDTO> backupJobInfos = new ArrayList<BackupJobInfoDTO>();

    private BackupJobInfosDTO() {
    }

    public BackupJobInfosDTO(List<BackupJobInfoDTO> backupJobInfos) {
        this();
        if (backupJobInfos != null) {
            this.backupJobInfos.addAll(backupJobInfos);
        }
    }

    public BackupJobInfosDTO(Map<String, Object> backupJobInfosData) {
        this();
        this.checkForWellKnownKeys(backupJobInfosData);
        this.backupJobInfos.addAll(MapUtil.getArrayValueAsListOfObjects(backupJobInfosData, (String)"backupJobs", BackupJobInfoDTO.class));
    }

    private void checkForWellKnownKeys(Map<String, Object> connectedServersData) {
        MapUtil.checkForWellKnownKeys(connectedServersData, Set.of("backupJobs"));
    }

    public BackupJobInfosDTO(StreamInput in) throws IOException {
        this();
        this.backupJobInfos.addAll(in.readList(BackupJobInfoDTO::new));
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeList(this.backupJobInfos);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.startArray("backupJobs");
        for (BackupJobInfoDTO backupJob : this.backupJobInfos) {
            backupJob.toXContent(builder, params);
        }
        builder.endArray();
        builder.endObject();
        return builder;
    }

    public boolean isEmpty() {
        return this.backupJobInfos.isEmpty();
    }

    public int size() {
        return this.backupJobInfos.size();
    }

    public BackupJobInfoDTO get(int index) {
        return this.backupJobInfos.get(index);
    }

    public List<BackupJobInfoDTO> getBackupJobInfos() {
        return new ArrayList<BackupJobInfoDTO>(this.backupJobInfos);
    }

    public Set<String> getBackupJobIdentifiers() {
        HashSet<String> result = new HashSet<String>();
        for (BackupJobInfoDTO backupJobInfo : this.backupJobInfos) {
            result.add(backupJobInfo.getBackupJobIdentifier());
        }
        return result;
    }

    public void sortByBackupJobIdentifier() {
        this.backupJobInfos.sort(new Comparator<BackupJobInfoDTO>(this){

            @Override
            public int compare(BackupJobInfoDTO o1, BackupJobInfoDTO o2) {
                return o1.getBackupJobIdentifier().compareTo(o2.getBackupJobIdentifier());
            }
        });
    }

    @Override
    public Iterator<BackupJobInfoDTO> iterator() {
        return this.backupJobInfos.iterator();
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BackupJobInfosDTO that = (BackupJobInfosDTO)o;
        return Objects.equals(this.backupJobInfos, that.backupJobInfos);
    }

    public int hashCode() {
        return Objects.hashCode(this.backupJobInfos);
    }

    public String toString() {
        return "BackupJobInfosDTO{backupJobInfos=" + String.valueOf(this.backupJobInfos) + "}";
    }
}

