/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.privileges;

import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.DocRequest;
import org.opensearch.common.settings.Settings;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.Strings;
import org.opensearch.security.privileges.PrivilegesEvaluationContext;
import org.opensearch.security.privileges.PrivilegesEvaluatorResponse;
import org.opensearch.security.resources.ResourceAccessHandler;

public class ResourceAccessEvaluator {
    private static final Logger log = LogManager.getLogger(ResourceAccessEvaluator.class);
    private final Set<String> resourceIndices;
    private final Settings settings;
    private final ResourceAccessHandler resourceAccessHandler;

    public ResourceAccessEvaluator(Set<String> resourceIndices, Settings settings, ResourceAccessHandler resourceAccessHandler) {
        this.resourceIndices = resourceIndices;
        this.settings = settings;
        this.resourceAccessHandler = resourceAccessHandler;
    }

    public void evaluateAsync(ActionRequest request, String action, PrivilegesEvaluationContext context, ActionListener<PrivilegesEvaluatorResponse> pResponseListener) {
        PrivilegesEvaluatorResponse pResponse = new PrivilegesEvaluatorResponse();
        log.debug("Evaluating resource access");
        DocRequest req = (DocRequest)request;
        this.resourceAccessHandler.hasPermission(req.id(), req.index(), action, context, (ActionListener<Boolean>)ActionListener.wrap(hasAccess -> {
            if (hasAccess.booleanValue()) {
                pResponse.allowed = true;
                pResponseListener.onResponse((Object)pResponse.markComplete());
                return;
            }
            pResponseListener.onResponse((Object)PrivilegesEvaluatorResponse.insufficient(action).markComplete());
        }, e -> pResponseListener.onResponse((Object)pResponse.markComplete())));
    }

    public boolean shouldEvaluate(ActionRequest request) {
        boolean isResourceSharingFeatureEnabled = this.settings.getAsBoolean("plugins.security.experimental.resource_sharing.enabled", Boolean.valueOf(false));
        if (!isResourceSharingFeatureEnabled) {
            return false;
        }
        if (!(request instanceof DocRequest)) {
            return false;
        }
        DocRequest docRequest = (DocRequest)request;
        if (Strings.isNullOrEmpty((String)docRequest.id())) {
            log.debug("Request id is blank or null, request is of type {}", (Object)docRequest.getClass().getName());
            return false;
        }
        if (!this.resourceIndices.contains(docRequest.index())) {
            log.debug("Request index {} is not a protected resource index", (Object)docRequest.index());
            return false;
        }
        return true;
    }
}

