/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.opensearch.plugin.websocket.message;

import de.virtimo.bpc.opensearch.plugin.utils.StringUtil;
import de.virtimo.bpc.opensearch.plugin.websocket.WebsocketMessage;
import de.virtimo.bpc.opensearch.plugin.websocket.WebsocketMessageException;

public class IndexDeletedWebsocketMessage
implements WebsocketMessage {
    private static final String PREFIX = "IndexDeleted:::";
    private final String indexName;

    public IndexDeletedWebsocketMessage(String indexName) {
        this.indexName = indexName;
    }

    public static boolean canBeCreatedFromMessage(String websocketMessage) {
        return !StringUtil.isNullOrEmpty((String)websocketMessage) && websocketMessage.startsWith(PREFIX);
    }

    public static IndexDeletedWebsocketMessage createFromMessage(String websocketMessage) {
        String indexName = websocketMessage.substring(PREFIX.length());
        return new IndexDeletedWebsocketMessage(indexName);
    }

    @Override
    public String getMessageToSend() throws WebsocketMessageException {
        return PREFIX + this.indexName;
    }

    public String getIndexName() {
        return this.indexName;
    }

    public String toString() {
        return "IndexDeletedWebsocketMessage{indexName='" + this.indexName + "'}";
    }
}

