/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.opensearch.plugin.dto;

import de.virtimo.bpc.opensearch.plugin.dto.OpenSearchPluginDTO;
import de.virtimo.bpc.opensearch.plugin.utils.MapUtil;
import de.virtimo.bpc.opensearch.plugin.utils.StringUtil;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;

public class ReplicationJobDTO
implements OpenSearchPluginDTO {
    private final String id;
    private final boolean enabled;
    private final int settingsHash;

    public ReplicationJobDTO(String id, boolean enabled, Integer settingsHash) {
        if (StringUtil.isNullOrEmpty((String)id)) {
            throw new NullPointerException("The 'id' cannot be null or empty");
        }
        Objects.requireNonNull(settingsHash, "settingsHash must not be null");
        this.id = id;
        this.enabled = enabled;
        this.settingsHash = settingsHash;
    }

    public ReplicationJobDTO(Map<String, Object> jobMap) {
        this(MapUtil.getValueAsString(jobMap, (String)"id", null), MapUtil.getValueAsBoolean(jobMap, (String)"enabled", (boolean)false), MapUtil.getValueAsInteger(jobMap, (String)"settingsHash", null));
        this.checkForWellKnownKeys(jobMap);
    }

    private void checkForWellKnownKeys(Map<String, Object> jobMap) {
        MapUtil.checkForWellKnownKeys(jobMap, Set.of("id", "enabled", "settingsHash"));
    }

    public ReplicationJobDTO(StreamInput in) throws IOException {
        this.id = in.readString();
        this.enabled = in.readBoolean();
        this.settingsHash = in.readVInt();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.id);
        out.writeBoolean(this.enabled);
        out.writeVInt(this.settingsHash);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("id", this.id);
        builder.field("enabled", this.enabled);
        builder.field("settingsHash", this.settingsHash);
        builder.endObject();
        return builder;
    }

    public static ReplicationJobDTO fromXContent(XContentParser parser) throws IOException {
        return new ReplicationJobDTO(parser.map());
    }

    public String getId() {
        return this.id;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public int getSettingsHash() {
        return this.settingsHash;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReplicationJobDTO that = (ReplicationJobDTO)o;
        return this.enabled == that.enabled && this.settingsHash == that.settingsHash && Objects.equals(this.id, that.id);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.enabled, this.settingsHash);
    }

    public String toString() {
        return "ReplicationJobDTO{id='" + this.id + "', enabled=" + this.enabled + ", settingsHash='" + this.settingsHash + "'}";
    }
}

