/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.opensearch.plugin;

import de.virtimo.bpc.opensearch.plugin.dto.OpenSearchPluginDTO;
import de.virtimo.bpc.opensearch.plugin.utils.MapUtil;
import de.virtimo.bpc.opensearch.plugin.utils.StringUtil;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;

public class ReplicationJob
implements OpenSearchPluginDTO {
    private final String id;
    private boolean enabled;
    private int settingsHash;
    private String serverUUID;
    private State state;
    private long lastModifiedTimestamp;

    public static long currentTimestamp() {
        return System.nanoTime();
    }

    public ReplicationJob(ReplicationJob fromJob) {
        this(fromJob.id, fromJob.enabled, fromJob.settingsHash, fromJob.serverUUID, fromJob.state, fromJob.lastModifiedTimestamp);
    }

    public ReplicationJob(Map<String, Object> replicationJobData) {
        this(MapUtil.getValueAsString(replicationJobData, (String)"id", null), MapUtil.getValueAsBoolean(replicationJobData, (String)"enabled", (boolean)true), MapUtil.getValueAsInteger(replicationJobData, (String)"settingsHash", null), MapUtil.getValueAsString(replicationJobData, (String)"serverUUID", null), State.valueOf(MapUtil.getValueAsString(replicationJobData, (String)"state", (String)"STOPPED")), MapUtil.getValueAsLong(replicationJobData, (String)"lastModifiedTimestamp", (long)ReplicationJob.currentTimestamp()));
        this.checkForWellKnownKeys(replicationJobData);
    }

    private void checkForWellKnownKeys(Map<String, Object> map) {
        MapUtil.checkForWellKnownKeys(map, Set.of("id", "enabled", "settingsHash", "serverUUID", "state", "lastModifiedTimestamp"));
    }

    public ReplicationJob(String id, boolean enabled, int settingsHash) {
        this(id, enabled, settingsHash, null, State.STOPPED, ReplicationJob.currentTimestamp());
    }

    public ReplicationJob(String id, boolean enabled, Integer settingsHash, String serverUUID, State state) {
        this(id, enabled, settingsHash, serverUUID, state, ReplicationJob.currentTimestamp());
    }

    private ReplicationJob(String id, boolean enabled, Integer settingsHash, String serverUUID, State state, long lastModifiedTimestamp) {
        if (StringUtil.isNullOrEmpty((String)id)) {
            throw new NullPointerException("The 'id' cannot be null or empty");
        }
        Objects.requireNonNull(settingsHash, "settingsHash must not be null");
        this.id = id;
        this.enabled = enabled;
        this.settingsHash = settingsHash;
        this.serverUUID = enabled ? serverUUID : null;
        this.state = enabled ? state : State.STOPPED;
        this.lastModifiedTimestamp = lastModifiedTimestamp;
    }

    public ReplicationJob(StreamInput in) throws IOException {
        this.id = in.readString();
        this.enabled = in.readBoolean();
        this.settingsHash = in.readInt();
        this.serverUUID = in.readOptionalString();
        this.state = (State)in.readEnum(State.class);
        this.lastModifiedTimestamp = in.readLong();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.id);
        out.writeBoolean(this.enabled);
        out.writeInt(this.settingsHash);
        out.writeOptionalString(this.serverUUID);
        out.writeEnum((Enum)this.state);
        out.writeLong(this.lastModifiedTimestamp);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("id", this.id);
        builder.field("enabled", this.enabled);
        builder.field("settingsHash", this.settingsHash);
        builder.field("serverUUID", this.serverUUID);
        builder.field("state", this.state.name());
        builder.field("lastModifiedTimestamp", this.lastModifiedTimestamp);
        builder.endObject();
        return builder;
    }

    public static ReplicationJob fromXContent(XContentParser parser) throws IOException {
        return new ReplicationJob(parser.map());
    }

    public String getId() {
        return this.id;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        if (!Objects.equals(this.enabled, enabled)) {
            this.lastModifiedTimestamp = ReplicationJob.currentTimestamp();
        }
        this.enabled = enabled;
        if (!enabled) {
            this.setAsStopped();
        }
    }

    public int getSettingsHash() {
        return this.settingsHash;
    }

    public void setSettingsHash(int settingsHash) {
        if (!Objects.equals(this.settingsHash, settingsHash)) {
            this.lastModifiedTimestamp = ReplicationJob.currentTimestamp();
        }
        this.settingsHash = settingsHash;
    }

    public String getServerUUID() {
        return this.serverUUID;
    }

    public void setServerUUID(String serverUUID) {
        if (!Objects.equals(this.serverUUID, serverUUID)) {
            this.lastModifiedTimestamp = ReplicationJob.currentTimestamp();
        }
        this.serverUUID = serverUUID;
    }

    public State getState() {
        return this.state;
    }

    public boolean isRunningOnSomeServer() {
        return this.isInState(List.of(State.STARTING, State.RUNNING)) && !StringUtil.isNullOrEmpty((String)this.serverUUID);
    }

    public boolean isInState(State state) {
        return state == this.state;
    }

    public boolean isInState(List<State> states) {
        if (states != null) {
            for (State state : states) {
                if (state != this.state) continue;
                return true;
            }
        }
        return false;
    }

    public void setAsStopped() {
        if (!Objects.equals((Object)this.state, (Object)State.STOPPED) || this.serverUUID != null) {
            this.lastModifiedTimestamp = ReplicationJob.currentTimestamp();
        }
        this.state = State.STOPPED;
        this.serverUUID = null;
    }

    public void setAsRunningOnServer(String serverUUID) {
        if (StringUtil.isNullOrEmpty((String)serverUUID)) {
            this.setAsStopped();
        } else {
            if (!Objects.equals((Object)this.state, (Object)State.RUNNING) || !Objects.equals(this.serverUUID, serverUUID)) {
                this.lastModifiedTimestamp = ReplicationJob.currentTimestamp();
            }
            this.state = State.RUNNING;
            this.serverUUID = serverUUID;
        }
    }

    public void setStateToStopRequested() {
        if (!Objects.equals((Object)this.state, (Object)State.STOPPING)) {
            this.lastModifiedTimestamp = ReplicationJob.currentTimestamp();
        }
        this.state = State.STOPPING;
    }

    public void setStateToStartRequested(String serverUUID) {
        if (StringUtil.isNullOrEmpty((String)serverUUID)) {
            this.setAsStopped();
        } else {
            if (!Objects.equals((Object)this.state, (Object)State.STARTING) || !Objects.equals(this.serverUUID, serverUUID)) {
                this.lastModifiedTimestamp = ReplicationJob.currentTimestamp();
            }
            this.state = State.STARTING;
            this.serverUUID = serverUUID;
        }
    }

    public long getLastModifiedTimestamp() {
        return this.lastModifiedTimestamp;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReplicationJob that = (ReplicationJob)o;
        return this.enabled == that.enabled && this.settingsHash == that.settingsHash && this.lastModifiedTimestamp == that.lastModifiedTimestamp && Objects.equals(this.id, that.id) && Objects.equals(this.serverUUID, that.serverUUID) && this.state == that.state;
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    public String toString() {
        return "ReplicationJob{id='" + this.id + "', enabled=" + this.enabled + ", settingsHash=" + this.settingsHash + ", serverUUID='" + this.serverUUID + "', state=" + String.valueOf((Object)this.state) + ", lastModifiedTimestamp=" + this.lastModifiedTimestamp + "}";
    }

    public static enum State {
        STARTING,
        RUNNING,
        STOPPING,
        STOPPED;

    }
}

