/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.opensearch.plugin.transport.action.replication.jobs.setmodel;

import de.virtimo.bpc.opensearch.plugin.ReplicationJobs;
import java.io.IOException;
import java.util.List;
import org.opensearch.action.ActionRequestValidationException;
import org.opensearch.action.ValidateActions;
import org.opensearch.action.support.nodes.BaseNodesRequest;
import org.opensearch.cluster.node.DiscoveryNode;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;

public class ReplicationJobsSetModelRequest
extends BaseNodesRequest<ReplicationJobsSetModelRequest> {
    private final String initiatedOnNode;
    private final ReplicationJobs replicationJobs;

    public ReplicationJobsSetModelRequest(String initiatedOnNode, List<DiscoveryNode> nodeRecipients, ReplicationJobs replicationJobs) {
        super(nodeRecipients.toArray(new DiscoveryNode[0]));
        this.initiatedOnNode = initiatedOnNode;
        this.replicationJobs = replicationJobs;
    }

    public ReplicationJobsSetModelRequest(StreamInput in) throws IOException {
        super(in);
        this.initiatedOnNode = in.readString();
        this.replicationJobs = (ReplicationJobs)in.readOptionalWriteable(ReplicationJobs::new);
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.initiatedOnNode);
        out.writeOptionalWriteable((Writeable)this.replicationJobs);
    }

    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (this.initiatedOnNode == null) {
            validationException = ValidateActions.addValidationError((String)"no 'initiatedOnNode' specified", validationException);
        }
        if (this.replicationJobs == null) {
            validationException = ValidateActions.addValidationError((String)"no 'replicationJobs' specified", (ActionRequestValidationException)validationException);
        }
        return validationException;
    }

    public String getInitiatedOnNode() {
        return this.initiatedOnNode;
    }

    public ReplicationJobs getReplicationJobs() {
        return this.replicationJobs;
    }
}

